/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.reification.PropXeqCHalfReif;
import org.chocosolver.solver.constraints.reification.PropXeqYHalfReif;
import org.chocosolver.solver.constraints.reification.PropXgeCHalfReif;
import org.chocosolver.solver.constraints.reification.PropXinSHalfReif;
import org.chocosolver.solver.constraints.reification.PropXleCHalfReif;
import org.chocosolver.solver.constraints.reification.PropXleYHalfReif;
import org.chocosolver.solver.constraints.reification.PropXneCHalfReif;
import org.chocosolver.solver.constraints.reification.PropXneYHalfReif;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public interface IReificationFactory
extends ISelf<Model> {
    default public void ifThenElse(Constraint ifCstr, Constraint thenCstr, Constraint elseCstr) {
        this.ifThenElse(ifCstr.reify(), thenCstr, elseCstr);
    }

    default public void ifThenElse(BoolVar ifVar, Constraint thenCstr, Constraint elseCstr) {
        this.ifThen(ifVar, thenCstr);
        this.ifThen(ifVar.not(), elseCstr);
    }

    default public void ifThen(Constraint ifCstr, Constraint thenCstr) {
        this.ifThen(ifCstr.reify(), thenCstr);
    }

    default public void ifThen(BoolVar ifVar, Constraint thenCstr) {
        if (ifVar.contains(1)) {
            if (ifVar.isInstantiated()) {
                thenCstr.post();
            } else if (thenCstr.isSatisfied() == ESat.FALSE) {
                thenCstr.ignore();
                ((Model)this.ref()).arithm((IntVar)ifVar, "=", 0).post();
            } else {
                ((Model)this.ref()).arithm((IntVar)ifVar, "<=", thenCstr.reify()).post();
            }
        } else {
            thenCstr.ignore();
        }
    }

    default public void ifOnlyIf(Constraint cstr1, Constraint cstr2) {
        this.reification(cstr1.reify(), cstr2);
    }

    default public void reification(BoolVar var, Constraint cstr) {
        ESat entail = cstr.isSatisfied();
        if (var.isInstantiatedTo(1)) {
            cstr.post();
        } else if (var.isInstantiatedTo(0)) {
            cstr.getOpposite().post();
        } else if (entail == ESat.TRUE) {
            cstr.ignore();
            ((Model)this.ref()).arithm((IntVar)var, "=", 1).post();
        } else if (entail == ESat.FALSE) {
            cstr.ignore();
            ((Model)this.ref()).arithm((IntVar)var, "=", 0).post();
        } else {
            cstr.reifyWith(var);
        }
    }

    default public void reifyXeqC(IntVar X, int C, BoolVar B) {
        if (((Model)this.ref()).getSolver().getSearchState() == SearchState.NEW) {
            if (X.isInstantiatedTo(C)) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 1).post();
                return;
            }
            if (!X.contains(C)) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 0).post();
                return;
            }
        }
        this.reifXrelC(X, "=", C, B);
    }

    default public void reifyXneC(IntVar X, int C, BoolVar B) {
        this.reifyXeqC(X, C, B.not());
    }

    default public void reifyXeqY(IntVar X, IntVar Y, BoolVar B) {
        if (X == Y) {
            ((Model)this.ref()).arithm((IntVar)B, "=", 1).post();
        } else if (X.isAConstant()) {
            this.reifyXeqC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXeqC(X, Y.getValue(), B);
        } else {
            this.reifyXeqYC(X, Y, 0, B);
        }
    }

    default public void reifyXneY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXneC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXneC(X, Y.getValue(), B);
        } else {
            this.reifyXeqY(X, Y, B.not());
        }
    }

    default public void reifyXeqYC(IntVar X, IntVar Y, int C, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXeqC(Y, X.getValue() - C, B);
        } else if (Y.isAConstant()) {
            this.reifyXeqC(X, Y.getValue() + C, B);
        } else {
            this.reifXrelYC(X, "=", Y, C, B);
        }
    }

    default public void reifyXneYC(IntVar X, IntVar Y, int C, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXneC(Y, X.getValue() - C, B);
        } else if (Y.isAConstant()) {
            this.reifyXneC(X, Y.getValue() + C, B);
        } else {
            this.reifyXeqYC(X, Y, C, B.not());
        }
    }

    default public void reifyXltC(IntVar X, int C, BoolVar B) {
        if (((Model)this.ref()).getSolver().getSearchState() == SearchState.NEW) {
            if (X.getUB() < C) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 1).post();
                return;
            }
            if (X.getLB() >= C) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 0).post();
                return;
            }
        }
        this.reifXrelC(X, "<", C, B);
    }

    default public void reifyXgtC(IntVar X, int C, BoolVar B) {
        this.reifyXltC(X, C + 1, B.not());
    }

    default public void reifyXltY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXgtC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXltC(X, Y.getValue(), B);
        } else {
            this.reifyXltYC(X, Y, 0, B);
        }
    }

    default public void reifyXgtY(IntVar X, IntVar Y, BoolVar B) {
        this.reifyXltYC(X, Y, 1, B.not());
    }

    default public void reifyXleY(IntVar X, IntVar Y, BoolVar B) {
        this.reifyXltYC(X, Y, 1, B);
    }

    default public void reifyXgeY(IntVar X, IntVar Y, BoolVar B) {
        this.reifyXltYC(X, Y, 0, B.not());
    }

    default public void reifyXltYC(IntVar X, IntVar Y, int C, BoolVar B) {
        if (X == Y) {
            if (C > 0) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 1).post();
            } else {
                ((Model)this.ref()).arithm((IntVar)B, "=", 0).post();
            }
        } else if (X.isAConstant()) {
            this.reifyXgtC(Y, X.getValue() - C, B);
        } else if (Y.isAConstant()) {
            this.reifyXltC(X, Y.getValue() + C, B);
        } else {
            this.reifXrelYC(X, "<", Y, C, B);
        }
    }

    default public void reifyXgtYC(IntVar X, IntVar Y, int C, BoolVar B) {
        this.reifyXltYC(X, Y, C + 1, B.not());
    }

    default public void reifyXinS(IntVar X, IntIterableRangeSet S, BoolVar B) {
        IntIterableRangeSet nS = S.duplicate().flip(X.getLB() - 1, X.getUB() + 1);
        ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXinSHalfReif(X, S, B), new PropXinSHalfReif(X, nS, B.not())));
    }

    default public void reifyXnotinS(IntVar X, IntIterableRangeSet S, BoolVar B) {
        IntIterableRangeSet nS = S.duplicate().flip(X.getLB() - 1, X.getUB() + 1);
        ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXinSHalfReif(X, S, B.not()), new PropXinSHalfReif(X, nS, B)));
    }

    default public void reifXrelC(IntVar X, String op, int C, BoolVar B) {
        switch (Operator.get(op)) {
            case EQ: {
                new Constraint("BASIC_REIF", new PropXeqCHalfReif(X, C, B), new PropXneCHalfReif(X, C, B.not())).post();
                break;
            }
            case NQ: {
                this.reifXrelC(X, "=", C, B.not());
                break;
            }
            case LT: {
                this.reifXrelC(X, "<=", C - 1, B);
                break;
            }
            case LE: {
                new Constraint("BASIC_REIF", new PropXleCHalfReif(X, C, B), new PropXgeCHalfReif(X, C + 1, B.not())).post();
                break;
            }
            case GT: {
                this.reifXrelC(X, ">=", C + 1, B);
                break;
            }
            case GE: {
                new Constraint("BASIC_REIF", new PropXgeCHalfReif(X, C, B), new PropXleCHalfReif(X, C - 1, B.not())).post();
                break;
            }
            default: {
                throw new SolverException("Unexpected operator: " + op);
            }
        }
    }

    default public void reifXrelYC(IntVar X, String op, IntVar Y, int C, BoolVar B) {
        if (Y.isInstantiated()) {
            this.reifXrelC(X, op, Y.getValue() + C, B);
            return;
        }
        switch (Operator.get(op)) {
            case EQ: {
                new Constraint("BASIC_REIF", new PropXeqYHalfReif(X, ((Model)this.ref()).intView(1, Y, C), B), new PropXneYHalfReif(X, ((Model)this.ref()).intView(1, Y, C), B.not())).post();
                break;
            }
            case NQ: {
                this.reifXrelYC(X, "=", Y, C, B.not());
                break;
            }
            case LT: {
                this.reifXrelYC(X, "<=", Y, C - 1, B);
                break;
            }
            case LE: {
                new Constraint("BASIC_REIF", new PropXleYHalfReif(X, ((Model)this.ref()).intView(1, Y, C), B), new PropXleYHalfReif(Y, ((Model)this.ref()).intView(1, X, -C - 1), B.not())).post();
                break;
            }
            case GT: {
                this.reifXrelYC(Y, "<=", X, -C - 1, B);
                break;
            }
            case GE: {
                this.reifXrelYC(Y, "<=", X, -C, B);
                break;
            }
            default: {
                throw new SolverException("Unexpected operator: " + op);
            }
        }
    }

    default public void impXrelC(IntVar X, String op, int C, BoolVar B) {
        switch (Operator.get(op)) {
            case EQ: {
                ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXeqCHalfReif(X, C, B)));
                break;
            }
            case NQ: {
                ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXneCHalfReif(X, C, B)));
                break;
            }
            case LT: {
                this.impXrelC(X, "<=", C - 1, B);
                break;
            }
            case LE: {
                ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXleCHalfReif(X, C, B)));
                break;
            }
            case GT: {
                this.impXrelC(X, ">=", C + 1, B);
                break;
            }
            case GE: {
                ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXgeCHalfReif(X, C, B)));
                break;
            }
            default: {
                throw new SolverException("Unexpected operator: " + op);
            }
        }
    }

    default public void impXrelYC(IntVar X, String op, IntVar Y, int C, BoolVar B) {
        if (Y.isInstantiated()) {
            this.impXrelC(X, op, Y.getValue() + C, B);
            return;
        }
        switch (Operator.get(op)) {
            case EQ: {
                ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXeqYHalfReif(X, ((Model)this.ref()).intView(1, Y, C), B)));
                break;
            }
            case NQ: {
                ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXneYHalfReif(X, ((Model)this.ref()).intView(1, Y, C), B)));
                break;
            }
            case LT: {
                this.impXrelYC(X, "<=", Y, C - 1, B);
                break;
            }
            case LE: {
                ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXleYHalfReif(X, ((Model)this.ref()).intView(1, Y, C), B)));
                break;
            }
            case GT: {
                this.impXrelYC(Y, "<=", X, -C - 1, B);
                break;
            }
            case GE: {
                this.impXrelYC(Y, "<=", X, -C, B);
                break;
            }
            default: {
                throw new SolverException("Unexpected operator: " + op);
            }
        }
    }
}

