/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.io.Closeable;
import java.io.IOException;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.trace.IMessage;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.iterators.DisposableRangeIterator;

public abstract class SearchViz
implements IMonitorDownBranch,
IMonitorUpBranch,
IMonitorSolution,
IMonitorContradiction,
IMonitorRestart,
Closeable {
    protected Solver mSolver;
    private final TIntStack pid_stack = new TIntArrayStack();
    private final TIntStack alt_stack = new TIntArrayStack();
    private final TIntStack last_stack = new TIntArrayStack();
    private int nc = 0;
    private int rid;
    private int last;
    protected boolean connected;
    private final boolean sendDomain;
    private final IMessage solutionMessage = new IMessage(){

        @Override
        public String print() {
            StringBuilder s = new StringBuilder(32);
            for (Variable v : SearchViz.this.mSolver.getModel().getVars()) {
                s.append(v).append(' ');
            }
            return s.toString();
        }
    };
    private final IMessage domainMessage = new IMessage(){

        @Override
        public String print() {
            StringBuilder s = new StringBuilder(32);
            s.append("{\"domains\":{");
            for (Variable v : SearchViz.this.mSolver.getModel().getVars()) {
                if ((v.getTypeAndKind() & 8) > 0) {
                    s.append("\"").append(v.getName()).append("\":\"");
                    IntVar iv = (IntVar)v;
                    DisposableRangeIterator rit = iv.getRangeIterator(true);
                    while (rit.hasNext()) {
                        int from = rit.min();
                        int to = rit.max();
                        s.append(from);
                        if (from < to) {
                            s.append("..").append(to);
                        }
                        s.append(',');
                        rit.next();
                    }
                    rit.dispose();
                }
                s.setLength(s.length() - 1);
                s.append("\",");
            }
            s.setLength(s.length() - 1);
            s.append("}}");
            return s.toString();
        }
    };

    public SearchViz(Solver aSolver, boolean sendDomain) {
        this.mSolver = aSolver;
        this.sendDomain = sendDomain;
        this.mSolver.plugMonitor(this);
        this.alt_stack.push(-1);
        this.pid_stack.push(-1);
        this.last_stack.push(-1);
    }

    protected abstract void disconnect();

    protected abstract void sendNode(int var1, int var2, int var3, int var4, int var5, String var6, String var7);

    protected abstract void sendSolution(int var1, int var2, int var3, int var4, int var5, String var6, String var7);

    protected abstract void sendFailure(int var1, int var2, int var3, int var4, int var5, String var6, String var7);

    protected abstract void sendRestart(int var1);

    @Override
    public final void close() throws IOException {
        this.disconnect();
        this.mSolver.unplugMonitor(this);
        this.connected = false;
    }

    @Override
    public final void beforeDownBranch(boolean left) {
        if (left) {
            DecisionPath dp = this.mSolver.getDecisionPath();
            int last = dp.size() - 1;
            if (last > 0) {
                String pdec = SearchViz.pretty(dp.getDecision(last - 1));
                Decision dec = dp.getLastDecision();
                int ari = dec.getArity();
                this.sendNode(this.nc, this.pid_stack.peek(), this.alt_stack.pop(), ari, this.rid, pdec, this.sendDomain ? this.domainMessage.print() : "");
                for (int i = 0; i < ari; ++i) {
                    this.pid_stack.push(this.nc);
                }
                ++this.nc;
                this.alt_stack.push(0);
                this.last_stack.push(this.nc - 1);
            }
        } else {
            ++this.nc;
            this.alt_stack.push(1);
            this.last_stack.push(this.last);
        }
    }

    @Override
    public final void beforeUpBranch() {
        this.last = this.last_stack.pop();
        while (this.pid_stack.peek() != this.last) {
            this.pid_stack.pop();
        }
        this.pid_stack.pop();
    }

    @Override
    public final void onSolution() {
        String dec = SearchViz.pretty(this.mSolver.getDecisionPath().getLastDecision());
        this.sendSolution(this.nc, this.pid_stack.peek(), this.alt_stack.pop(), 0, this.rid, dec, this.solutionMessage.print());
    }

    @Override
    public final void onContradiction(ContradictionException cex) {
        String dec = SearchViz.pretty(this.mSolver.getDecisionPath().getLastDecision());
        this.sendFailure(this.nc, this.pid_stack.peek(), this.alt_stack.pop(), 0, this.rid, dec, cex.toString());
    }

    @Override
    public final void afterRestart() {
        this.sendRestart(++this.rid);
        this.pid_stack.clear();
        this.alt_stack.clear();
        this.alt_stack.push(-1);
        this.pid_stack.push(-1);
        this.last_stack.push(-1);
        this.nc = 0;
    }

    private static String pretty(Decision dec) {
        if (dec == null) {
            return "ROOT";
        }
        int a = dec.getArity();
        int b = dec.triesLeft();
        dec.rewind();
        while (dec.triesLeft() > b + 1) {
            --a;
            dec.buildNext();
        }
        String pretty = dec.toString();
        while (a > b) {
            ++b;
            dec.buildNext();
        }
        return pretty;
    }
}

