/*
 * Decompiled with CFR 0.152.
 */
package jdplus.text.base.r;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jdplus.text.base.api.TxtBean;
import jdplus.text.base.api.TxtProvider;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.util.ObsFormat;
import jdplus.toolkit.base.tsp.util.PropertyHandler;
import lombok.Generated;

public final class TxtFiles {
    private static final TxtProvider PROVIDER = new TxtProvider();

    static TxtProvider currentProvider() {
        return TsFactory.getDefault().getProvider("Txt").orElse(null);
    }

    public static String changeFile(String id, String nfile, String ofile) {
        Optional set = PROVIDER.toDataSet(TsMoniker.of((String)"Txt", (String)id));
        Optional<String> m = set.map(d -> {
            TxtBean bean = PROVIDER.decodeBean(d.getDataSource());
            if (ofile.isBlank() || bean.getFile().getName().equals(ofile)) {
                bean.setFile(Path.of(nfile, new String[0]).toFile());
                DataSource src = PROVIDER.encodeBean((Object)bean);
                DataSet nd = d.toBuilder().dataSource(src).build();
                return PROVIDER.toMoniker(nd).getId();
            }
            return id;
        });
        return m.orElse(id);
    }

    public static DataSource source(String file, ObsFormat obsFormat, ObsGathering obsGathering, String cs, String delimiter, String txtqualifier, boolean headers, int skiplines) {
        TxtBean bean = new TxtBean();
        bean.setFile(Path.of(file, new String[0]).toFile());
        if (cs != null && cs.length() > 0) {
            bean.setCharset(Charset.forName(cs));
        }
        if (delimiter != null) {
            bean.setDelimiter(TxtBean.Delimiter.valueOf((String)delimiter));
        }
        if (txtqualifier != null) {
            bean.setTextQualifier(TxtBean.TextQualifier.valueOf((String)txtqualifier));
        }
        if (obsFormat != null) {
            bean.setFormat(obsFormat);
        }
        if (obsGathering != null) {
            bean.setGathering(obsGathering);
        }
        bean.setHeaders(headers);
        bean.setSkipLines(skiplines);
        return PROVIDER.encodeBean((Object)bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] series(DataSource source) throws Exception {
        TxtProvider currentProvider = TxtFiles.currentProvider();
        if (currentProvider == null) {
            throw new Exception("TxtProvider is not available");
        }
        try {
            currentProvider.open(source);
            List all = currentProvider.children(source);
            String[] stringArray = (String[])all.stream().map(s -> currentProvider.getDisplayNodeName(s)).toArray(String[]::new);
            return stringArray;
        }
        finally {
            currentProvider.close(source);
        }
    }

    public static String seriesIdentifier(DataSource source, int series) throws IllegalArgumentException, IOException {
        TxtProvider currentProvider = TxtFiles.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("TxtProvider is not available");
        }
        DataSet.Converter seriesParam = PropertyHandler.onInteger((String)"seriesIndex", (int)-1).asDataSetConverter();
        DataSet.Builder builder = DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.SERIES);
        seriesParam.set(builder, (Object)(series - 1));
        return currentProvider.toMoniker(builder.build()).getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ts series(DataSource source, int series) throws IllegalArgumentException, IOException {
        TxtProvider currentProvider = TxtFiles.currentProvider();
        if (currentProvider == null) {
            throw new RuntimeException("TxtProvider is not available");
        }
        try {
            currentProvider.open(source);
            List all = currentProvider.children(source);
            if (series > all.size()) {
                throw new IllegalArgumentException("Invalid sheet");
            }
            DataSet s = (DataSet)all.get(series - 1);
            TsMoniker moniker = currentProvider.toMoniker(s);
            Ts ts = currentProvider.getTs(moniker, TsInformationType.All);
            return ts;
        }
        finally {
            currentProvider.close(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TsCollection collection(DataSource source) throws Exception {
        TxtProvider currentProvider = TxtFiles.currentProvider();
        if (currentProvider == null) {
            throw new Exception("TxtProvider is not available");
        }
        try {
            currentProvider.open(source);
            TsMoniker moniker = currentProvider.toMoniker(source);
            TsCollection tsCollection = currentProvider.getTsCollection(moniker, TsInformationType.All);
            return tsCollection;
        }
        finally {
            currentProvider.close(source);
        }
    }

    public static void setPaths(String[] paths) throws Exception {
        TxtProvider provider = TxtFiles.currentProvider();
        if (provider == null) {
            throw new Exception("TxtProvider is not available");
        }
        File[] files = (File[])Arrays.stream(paths).map(p -> Path.of(p, new String[0]).toFile()).toArray(File[]::new);
        provider.setPaths(files);
    }

    public static DataSet decode(String id) {
        Optional set = PROVIDER.toDataSet(TsMoniker.of((String)"Txt", (String)id));
        return set.orElse(null);
    }

    public static String encode(DataSet set) {
        return PROVIDER.toMoniker(set).getId();
    }

    public static TxtBean sourceOf(DataSet set) {
        return PROVIDER.decodeBean(set.getDataSource());
    }

    public static DataSet sheetDataSet(DataSource source) {
        return DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.COLLECTION).build();
    }

    public static DataSet seriesDataSet(DataSource source, int series) {
        return DataSet.builder((DataSource)source, (DataSet.Kind)DataSet.Kind.SERIES).parameter("seriesIndex", Integer.toString(series - 1)).build();
    }

    @Generated
    private TxtFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

