/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.integration;

import internal.toolkit.base.core.math.functions.gsl.Utility;
import internal.toolkit.base.core.math.functions.gsl.integration.GslIntegrationException;
import internal.toolkit.base.core.math.functions.gsl.integration.IntegrationResult;
import internal.toolkit.base.core.math.functions.gsl.integration.IntegrationRule;
import internal.toolkit.base.core.math.functions.gsl.integration.QK21;
import java.util.function.DoubleUnaryOperator;
import lombok.NonNull;

public class QAGS {
    private final double epsabs;
    private final double epsrel;
    private final int limit;
    private final IntegrationRule q;
    private double result;
    private double abserr;
    private int iteration;

    public static Builder builder() {
        return new Builder();
    }

    private QAGS(double epsabs, double epsrel, int limit, IntegrationRule rule) {
        this.epsabs = epsabs;
        this.epsrel = epsrel;
        this.limit = limit;
        this.q = rule;
    }

    public void integrate(DoubleUnaryOperator fn, double a, double b) {
        Workspace workspace = new Workspace(this.limit);
        double ertest = 0.0;
        double error_over_large_intervals = 0.0;
        double correc = 0.0;
        int ktmin = 0;
        int roundoff_type1 = 0;
        int roundoff_type2 = 0;
        int roundoff_type3 = 0;
        int error_type = 0;
        boolean error_type2 = false;
        boolean extrapolate = false;
        boolean disallow_extrapolation = false;
        ExtrapolationTable table = new ExtrapolationTable();
        workspace.alist[0] = a;
        workspace.blist[0] = b;
        this.result = 0.0;
        this.abserr = 0.0;
        if (this.limit > workspace.limit) {
            throw new GslIntegrationException("iteration limit exceeds available workspace");
        }
        if (this.epsabs <= 0.0 && (this.epsrel < (double)1.110223E-14f || this.epsrel < 5.0E-29)) {
            throw new GslIntegrationException("tolerance cannot be achieved with given epsabs and epsrel");
        }
        IntegrationResult rslt0 = this.q.integrate(fn, a, b);
        workspace.setInitialResult(rslt0);
        double tolerance = Math.max(this.epsabs, this.epsrel * Math.abs(rslt0.getResult()));
        if (rslt0.getAbsError() <= 2.220446049250313E-14 * rslt0.getResultAbs() && rslt0.getAbsError() > tolerance) {
            this.result = rslt0.getResult();
            this.abserr = rslt0.getAbsError();
            throw new GslIntegrationException("cannot reach tolerance because of roundoff error on first attempt");
        }
        if (rslt0.getAbsError() <= tolerance && rslt0.getAbsError() != rslt0.getResultAsc() || rslt0.getAbsError() == 0.0) {
            this.result = rslt0.getResult();
            this.abserr = rslt0.getAbsError();
            return;
        }
        if (this.limit == 1) {
            this.result = rslt0.getResult();
            this.abserr = rslt0.getAbsError();
            throw new GslIntegrationException("a maximum of one iteration was insufficient");
        }
        table.initialise();
        table.append(rslt0.getResult());
        double area = rslt0.getResult();
        double errsum = rslt0.getAbsError();
        double res_ext = rslt0.getResult();
        double err_ext = Double.MAX_VALUE;
        boolean positive_integrand = Utility.test_positivity(rslt0.getResult(), rslt0.getResultAbs());
        this.iteration = 1;
        do {
            double b1;
            double a_i = workspace.a();
            double b_i = workspace.b();
            double r_i = workspace.r();
            double e_i = workspace.e();
            int current_level = workspace.level() + 1;
            double a1 = a_i;
            double a2 = b1 = 0.5 * (a_i + b_i);
            double b2 = b_i;
            ++this.iteration;
            IntegrationResult rslt1 = this.q.integrate(fn, a1, b1);
            IntegrationResult rslt2 = this.q.integrate(fn, a2, b2);
            double area1 = rslt1.getResult();
            double area2 = rslt2.getResult();
            double area12 = area1 + area2;
            double error1 = rslt1.getAbsError();
            double error2 = rslt2.getAbsError();
            double error12 = error1 + error2;
            double last_e_i = e_i;
            errsum = errsum + error12 - e_i;
            area = area + area12 - r_i;
            tolerance = Math.max(this.epsabs, this.epsrel * Math.abs(area));
            if (rslt1.getResultAsc() != error1 && rslt2.getResultAsc() != error2) {
                double delta = r_i - area12;
                if (Math.abs(delta) <= 1.0E-5 * Math.abs(area12) && error12 >= 0.99 * e_i) {
                    if (!extrapolate) {
                        ++roundoff_type1;
                    } else {
                        ++roundoff_type2;
                    }
                }
                if (this.iteration > 10 && error12 > e_i) {
                    ++roundoff_type3;
                }
            }
            if (roundoff_type1 + roundoff_type2 >= 10 || roundoff_type3 >= 20) {
                error_type = 2;
            }
            if (roundoff_type2 >= 5) {
                error_type2 = true;
            }
            if (Utility.subinterval_too_small(a1, a2, b2)) {
                error_type = 4;
            }
            workspace.update(a1, b1, area1, error1, a2, b2, area2, error2);
            if (errsum <= tolerance) {
                this.computeResult(workspace, errsum, error_type);
                return;
            }
            if (error_type != 0) break;
            if (this.iteration >= this.limit - 1) {
                error_type = 1;
                break;
            }
            if (this.iteration == 2) {
                error_over_large_intervals = errsum;
                ertest = tolerance;
                table.append(area);
                continue;
            }
            if (disallow_extrapolation) continue;
            error_over_large_intervals += -last_e_i;
            if (current_level < workspace.maximum_level) {
                error_over_large_intervals += error12;
            }
            if (!extrapolate) {
                if (workspace.isLargeInterval()) continue;
                extrapolate = true;
                workspace.nrmax = 1;
            }
            if (!error_type2 && error_over_large_intervals > ertest && workspace.increaseNrmax()) continue;
            table.append(area);
            table.qelg();
            if (++ktmin > 5 && err_ext < 0.001 * errsum) {
                error_type = 5;
            }
            if (table.abserr < err_ext) {
                ktmin = 0;
                err_ext = table.abserr;
                res_ext = table.result;
                correc = error_over_large_intervals;
                ertest = Math.max(this.epsabs, this.epsrel * Math.abs(table.result));
                if (err_ext <= ertest) break;
            }
            if (table.n == 1) {
                disallow_extrapolation = true;
            }
            if (error_type == 5) break;
            workspace.resetNrmax();
            extrapolate = false;
            error_over_large_intervals = errsum;
        } while (this.iteration < this.limit);
        this.result = res_ext;
        this.abserr = err_ext;
        if (err_ext == Double.MAX_VALUE) {
            this.computeResult(workspace, errsum, error_type);
            return;
        }
        if (error_type != 0 || error_type2) {
            if (error_type2) {
                err_ext += correc;
            }
            if (error_type == 0) {
                error_type = 3;
            }
            if (res_ext != 0.0 && area != 0.0) {
                if (err_ext / Math.abs(res_ext) > errsum / Math.abs(area)) {
                    this.computeResult(workspace, errsum, error_type);
                    return;
                }
            } else {
                if (err_ext > errsum) {
                    this.computeResult(workspace, errsum, error_type);
                    return;
                }
                if (area == 0.0) {
                    this.returnError(error_type);
                    return;
                }
            }
        }
        double max_area = Math.max(Math.abs(res_ext), Math.abs(area));
        if (!positive_integrand && max_area < 0.01 * rslt0.getAbsError()) {
            this.computeResult(workspace, errsum, error_type);
            return;
        }
        double ratio = res_ext / area;
        if (ratio < 0.01 || ratio > 100.0 || errsum > Math.abs(area)) {
            error_type = 6;
        }
        this.returnError(error_type);
    }

    private void computeResult(Workspace workspace, double errsum, int errorType) {
        this.result = workspace.sumResults();
        this.abserr = errsum;
        this.returnError(errorType);
    }

    private void returnError(int error_type) {
        if (error_type > 2) {
            --error_type;
        }
        if (error_type == 0) {
            return;
        }
        switch (error_type) {
            case 1: {
                throw new GslIntegrationException("number of iterations was insufficient");
            }
            case 2: {
                throw new GslIntegrationException("cannot reach tolerance because of roundoff error");
            }
            case 3: {
                throw new GslIntegrationException("bad integrand behavior found in the integration interval");
            }
            case 4: {
                throw new GslIntegrationException("roundoff error detected in the extrapolation table");
            }
            case 5: {
                throw new GslIntegrationException("integral is divergent, or slowly convergent");
            }
        }
        throw new GslIntegrationException("could not integrate function");
    }

    public double getResult() {
        return this.result;
    }

    public double getAbserr() {
        return this.abserr;
    }

    public static class Builder {
        private double epsabs;
        private double epsrel;
        private int limit;
        private IntegrationRule rule;

        public Builder() {
            this.epsrel = this.epsabs = Math.pow(2.220446049250313E-16, 0.5);
            this.limit = 100;
            this.rule = QK21.rule();
        }

        public Builder absoluteTolerance(double epsabs) {
            this.epsabs = epsabs;
            return this;
        }

        public Builder relativeTolerance(double epsrel) {
            this.epsrel = epsrel;
            return this;
        }

        public Builder segmentationLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder integrationRule(@NonNull IntegrationRule rule) {
            if (rule == null) {
                throw new NullPointerException("rule is marked non-null but is null");
            }
            this.rule = rule;
            return this;
        }

        public QAGS build() {
            return new QAGS(this.epsabs, this.epsrel, this.limit, this.rule);
        }
    }

    static class Workspace {
        final int limit;
        int size;
        int nrmax;
        int i;
        int maximum_level;
        final double[] alist;
        final double[] blist;
        final double[] rlist;
        final double[] elist;
        final int[] order;
        final int[] level;

        Workspace(int n) {
            this.alist = new double[n];
            this.blist = new double[n];
            this.rlist = new double[n];
            this.elist = new double[n];
            this.order = new int[n];
            this.level = new int[n];
            this.limit = n;
        }

        double a() {
            return this.alist[this.i];
        }

        double b() {
            return this.blist[this.i];
        }

        double r() {
            return this.rlist[this.i];
        }

        double e() {
            return this.elist[this.i];
        }

        int level() {
            return this.level[this.i];
        }

        int order() {
            return this.order[this.i];
        }

        void setInitialResult(IntegrationResult rslt0) {
            this.rlist[0] = rslt0.getResult();
            this.elist[0] = rslt0.getAbsError();
            this.size = 1;
        }

        void update(double a1, double b1, double area1, double error1, double a2, double b2, double area2, double error2) {
            int i_max = this.i;
            int i_new = this.size;
            int new_level = this.level[i_max] + 1;
            if (error2 > error1) {
                this.alist[i_max] = a2;
                this.rlist[i_max] = area2;
                this.elist[i_max] = error2;
                this.level[i_max] = new_level;
                this.alist[i_new] = a1;
                this.blist[i_new] = b1;
                this.rlist[i_new] = area1;
                this.elist[i_new] = error1;
                this.level[i_new] = new_level;
            } else {
                this.blist[i_max] = b1;
                this.rlist[i_max] = area1;
                this.elist[i_max] = error1;
                this.level[i_max] = new_level;
                this.alist[i_new] = a2;
                this.blist[i_new] = b2;
                this.rlist[i_new] = area2;
                this.elist[i_new] = error2;
                this.level[i_new] = new_level;
            }
            ++this.size;
            if (new_level > this.maximum_level) {
                this.maximum_level = new_level;
            }
            this.sort();
        }

        void sort() {
            int i_cur;
            int i_nrmax;
            int last = this.size - 1;
            int i_maxerr = this.order[i_nrmax];
            if (last < 2) {
                this.order[0] = 0;
                this.order[1] = 1;
                this.i = i_maxerr;
                return;
            }
            double errmax = this.elist[i_maxerr];
            for (i_nrmax = this.nrmax; i_nrmax > 0 && errmax > this.elist[this.order[i_nrmax - 1]]; --i_nrmax) {
                this.order[i_nrmax] = this.order[i_nrmax - 1];
            }
            int top = last < this.limit / 2 + 2 ? last : this.limit - last + 1;
            for (i_cur = i_nrmax + 1; i_cur < top && errmax < this.elist[this.order[i_cur]]; ++i_cur) {
                this.order[i_cur - 1] = this.order[i_cur];
            }
            this.order[i_cur - 1] = i_maxerr;
            double errmin = this.elist[last];
            for (int k = top - 1; k > i_cur - 2 && errmin >= this.elist[this.order[k]]; --k) {
                this.order[k + 1] = this.order[k];
            }
            this.order[k + 1] = last;
            this.i = i_maxerr = this.order[i_nrmax];
            this.nrmax = i_nrmax;
        }

        boolean isLargeInterval() {
            return this.level[this.i] < this.maximum_level;
        }

        private boolean increaseNrmax() {
            int id = this.nrmax;
            int last = this.size - 1;
            int jupbnd = last > 1 + this.limit / 2 ? this.limit + 1 - last : last;
            for (int k = id; k <= jupbnd; ++k) {
                int i_max;
                this.i = i_max = this.order[this.nrmax];
                if (this.level[i_max] < this.maximum_level) {
                    return true;
                }
                ++this.nrmax;
            }
            return false;
        }

        private void resetNrmax() {
            this.nrmax = 0;
            this.i = this.order[0];
        }

        private double sumResults() {
            double result_sum = 0.0;
            for (int k = 0; k < this.size; ++k) {
                result_sum += this.rlist[k];
            }
            return result_sum;
        }
    }

    static class ExtrapolationTable {
        int n;
        final double[] rlist2 = new double[52];
        int nres;
        final double[] res3la = new double[3];
        private double result;
        private double abserr;

        ExtrapolationTable() {
        }

        void initialise() {
            this.n = 0;
            this.nres = 0;
        }

        void append(double y) {
            this.rlist2[this.n] = y;
            ++this.n;
        }

        void qelg() {
            int i;
            int m = this.n - 1;
            double current = this.rlist2[m];
            double absolute = Double.MAX_VALUE;
            double relative = (double)1.110223E-15f * Math.abs(current);
            int newelm = m / 2;
            int n_orig = m;
            int n_final = m;
            int nres_orig = this.nres;
            this.result = current;
            this.abserr = Double.MAX_VALUE;
            if (m < 2) {
                this.result = current;
                this.abserr = Math.max(absolute, relative);
                return;
            }
            this.rlist2[m + 2] = this.rlist2[m];
            this.rlist2[m] = Double.MAX_VALUE;
            for (i = 0; i < newelm; ++i) {
                double tol1;
                double res = this.rlist2[m - 2 * i + 2];
                double e0 = this.rlist2[m - 2 * i - 2];
                double e1 = this.rlist2[m - 2 * i - 1];
                double e2 = res;
                double e1abs = Math.abs(e1);
                double delta2 = e2 - e1;
                double err2 = Math.abs(delta2);
                double tol2 = Math.max(Math.abs(e2), e1abs) * 2.220446049250313E-16;
                double delta3 = e1 - e0;
                double err3 = Math.abs(delta3);
                double tol3 = Math.max(e1abs, Math.abs(e0)) * 2.220446049250313E-16;
                if (err2 <= tol2 && err3 <= tol3) {
                    this.result = res;
                    absolute = err2 + err3;
                    relative = (double)1.110223E-15f * Math.abs(res);
                    this.abserr = Math.max(absolute, relative);
                    return;
                }
                double e3 = this.rlist2[m - 2 * i];
                this.rlist2[m - 2 * i] = e1;
                double delta1 = e1 - e3;
                double err1 = Math.abs(delta1);
                if (err1 <= (tol1 = Math.max(e1abs, Math.abs(e3)) * 2.220446049250313E-16) || err2 <= tol2 || err3 <= tol3) {
                    n_final = 2 * i;
                    break;
                }
                double ss = 1.0 / delta1 + 1.0 / delta2 - 1.0 / delta3;
                if (Math.abs(ss * e1) <= 1.0E-4) {
                    n_final = 2 * i;
                    break;
                }
                this.rlist2[m - 2 * i] = res = e1 + 1.0 / ss;
                double error = err2 + Math.abs(res - e2) + err3;
                if (!(error <= this.abserr)) continue;
                this.abserr = error;
                this.result = res;
            }
            int limexp = 49;
            if (n_final == 49) {
                n_final = 48;
            }
            if (n_orig % 2 == 1) {
                for (i = 0; i <= newelm; ++i) {
                    this.rlist2[1 + i * 2] = this.rlist2[i * 2 + 3];
                }
            } else {
                for (i = 0; i <= newelm; ++i) {
                    this.rlist2[i * 2] = this.rlist2[i * 2 + 2];
                }
            }
            if (n_orig != n_final) {
                for (i = 0; i <= n_final; ++i) {
                    this.rlist2[i] = this.rlist2[n_orig - n_final + i];
                }
            }
            this.n = n_final + 1;
            if (nres_orig < 3) {
                this.res3la[nres_orig] = this.result;
                this.abserr = Double.MAX_VALUE;
            } else {
                this.abserr = Math.abs(this.result - this.res3la[2]) + Math.abs(this.result - this.res3la[1]) + Math.abs(this.result - this.res3la[0]);
                this.res3la[0] = this.res3la[1];
                this.res3la[1] = this.res3la[2];
                this.res3la[2] = this.result;
            }
            this.nres = nres_orig + 1;
            this.abserr = Math.max(this.abserr, (double)1.110223E-15f * Math.abs(this.result));
        }
    }
}

