/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.minpack;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.functions.minpack.LevenbergMarquardtEstimator;
import jdplus.toolkit.base.core.math.functions.minpack.SsqEstimationProblem;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class MinPackMinimizer
implements SsqFunctionMinimizer {
    private LevenbergMarquardtEstimator m_estimator = new LevenbergMarquardtEstimator();
    private SsqEstimationProblem m_problem;

    public static MinPackBuilder builder() {
        return new MinPackBuilder();
    }

    private MinPackMinimizer(MinPackBuilder builder) {
        this.m_estimator.setMaxIter(builder.maxIter);
        this.m_estimator.setCostRelativeTolerance(builder.fnPrecision);
        this.m_estimator.setParametersRelativeTolerance(builder.paramPrecision);
        this.m_estimator.setOrthogonalTolerance(builder.orthogonalTolerance);
    }

    @Override
    public FastMatrix curvatureAtMinimum() {
        try {
            return this.m_estimator.curvature(this.m_problem);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public DoubleSeq gradientAtMinimum() {
        return this.m_problem.gradient();
    }

    @Override
    public ISsqFunctionPoint getResult() {
        return this.m_problem.getResult();
    }

    @Override
    public double getObjective() {
        return this.m_problem.getResult() == null ? Double.NaN : this.m_problem.getResult().getSsqE();
    }

    @Override
    public int getIterationsCount() {
        return this.m_estimator.getIterCount();
    }

    @Override
    public boolean minimize(ISsqFunctionPoint start) {
        this.m_problem = new SsqEstimationProblem(start);
        try {
            this.m_estimator.estimate(this.m_problem);
            return this.m_estimator.getIterCount() < this.m_estimator.getMaxIter();
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    public static class MinPackBuilder
    implements SsqFunctionMinimizer.Builder {
        private double fnPrecision = 1.0E-7;
        private double paramPrecision = 1.0E-7;
        private double orthogonalTolerance = 1.0E-7;
        private int maxIter = 1000;

        private MinPackBuilder() {
        }

        @Override
        public MinPackBuilder functionPrecision(double eps) {
            this.fnPrecision = eps;
            return this;
        }

        public MinPackBuilder parametersPrecision(double eps) {
            this.paramPrecision = eps;
            return this;
        }

        public MinPackBuilder orthogonalTolerance(double eps) {
            this.orthogonalTolerance = eps;
            return this;
        }

        @Override
        public MinPackBuilder maxIter(int niter) {
            this.maxIter = niter;
            return this;
        }

        @Override
        public MinPackMinimizer build() {
            return new MinPackMinimizer(this);
        }
    }
}

