/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfLoading;

public class WeightedLoading
implements ISsfLoading {
    private final IntToDoubleFunction weights;
    private final ISsfLoading loading;
    private final boolean timeInvariantWeights;

    public static WeightedLoading of(ISsfLoading loading, IntToDoubleFunction weights) {
        return new WeightedLoading(loading, weights, false);
    }

    public static WeightedLoading of(ISsfLoading loading, double w) {
        return new WeightedLoading(loading, i -> w, true);
    }

    private WeightedLoading(ISsfLoading loading, IntToDoubleFunction weights, boolean timeInvariant) {
        this.weights = weights;
        this.loading = loading;
        this.timeInvariantWeights = timeInvariant;
    }

    public IntToDoubleFunction getWeights() {
        return this.weights;
    }

    @Override
    public void Z(int pos, DataBlock z) {
        this.loading.Z(pos, z);
        z.mul(this.weights.applyAsDouble(pos));
    }

    @Override
    public double ZX(int pos, DataBlock m) {
        return this.weights.applyAsDouble(pos) * this.loading.ZX(pos, m);
    }

    @Override
    public double ZVZ(int pos, FastMatrix V) {
        double w = this.weights.applyAsDouble(pos);
        return this.loading.ZVZ(pos, V) * w * w;
    }

    @Override
    public void VpZdZ(int pos, FastMatrix V, double d) {
        if (d == 0.0) {
            return;
        }
        double w = this.weights.applyAsDouble(pos);
        this.loading.VpZdZ(pos, V, w * w * d);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        this.loading.XpZd(pos, x, d * this.weights.applyAsDouble(pos));
    }

    @Override
    public boolean isTimeInvariant() {
        return this.loading.isTimeInvariant() && this.timeInvariantWeights;
    }
}

