/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.strings;

public class Tokenizer {
    private final String input;
    private int curpos = 0;
    private final char delimiter;
    private final boolean ws;

    public Tokenizer(String s) {
        this.input = s;
        this.ws = true;
        this.delimiter = '\u0000';
    }

    public Tokenizer(String s, char delimiter) {
        this.input = s;
        this.ws = false;
        this.delimiter = delimiter;
    }

    public boolean hasNextToken() {
        if (this.ws) {
            while (this.curpos < this.input.length() && Character.isWhitespace(this.input.charAt(this.curpos))) {
                ++this.curpos;
            }
            return this.curpos < this.input.length();
        }
        return this.curpos < this.input.length();
    }

    public String nextToken() {
        int cur = this.curpos;
        if (this.ws) {
            while (this.curpos < this.input.length() && !Character.isWhitespace(this.input.charAt(this.curpos))) {
                ++this.curpos;
            }
            String sub = this.input.substring(cur, this.curpos);
            return sub;
        }
        while (this.curpos < this.input.length() && this.input.charAt(this.curpos) != this.delimiter) {
            ++this.curpos;
        }
        String sub = this.input.substring(cur, this.curpos++);
        return sub;
    }
}

