/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovDiagnostics;
import jdplus.tramoseats.base.core.seats.SeatsResults;

public class SeatsTests {
    private final SeatsResults results;
    private volatile WienerKolmogorovDiagnostics wkDiagnostics;

    public SeatsTests(SeatsResults results) {
        this.results = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WienerKolmogorovDiagnostics wkDiagnostics() {
        WienerKolmogorovDiagnostics tests = this.wkDiagnostics;
        if (tests == null) {
            SeatsTests seatsTests = this;
            synchronized (seatsTests) {
                tests = this.wkDiagnostics;
                if (tests == null) {
                    SeriesDecomposition decomposition = this.results.getInitialComponents();
                    UcarimaModel ucm = this.results.getCompactUcarimaModel();
                    int[] cmps = new int[]{1, -2, 2, 3};
                    double err = Math.sqrt(this.results.getInnovationVariance());
                    TsData t = decomposition.getSeries(ComponentType.Trend, ComponentInformation.Value);
                    TsData s = decomposition.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
                    TsData i = decomposition.getSeries(ComponentType.Irregular, ComponentInformation.Value);
                    TsData sa = decomposition.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
                    double[][] data = new double[][]{t == null ? null : t.getValues().toArray(), sa == null ? null : sa.getValues().toArray(), s == null ? null : s.getValues().toArray(), i == null ? null : i.getValues().toArray()};
                    this.wkDiagnostics = tests = WienerKolmogorovDiagnostics.make((UcarimaModel)ucm, (double)err, (double[][])data, (int[])cmps);
                }
            }
        }
        return tests;
    }

    public boolean isModelChanged() {
        return this.results.isModelChanged();
    }

    public boolean isParametersCutOff() {
        return this.results.isParametersCutOff();
    }

    public SarimaModel finalModel() {
        return this.results.getFinalModel();
    }

    public SarimaModel originalModel() {
        return this.results.getOriginalModel();
    }

    public UcarimaModel ucarimaModel() {
        return this.results.getUcarimaModel();
    }
}

