/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.sa.base.core.tests.SeasonalityTests;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.core.tramo.ModelComparator;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.TramoContext;

class SeasonalUnderDifferencingTest
extends ModelController {
    private static final String SEAS_UNDERDIFF = "Seasonal under-differencing has been fixed";
    private static final double DEF_SBOUND = 0.91;

    SeasonalUnderDifferencingTest() {
    }

    @Override
    ProcessingResult process(RegSarimaModelling modelling, TramoContext context) {
        ProcessingLog log = modelling.getLog();
        int period = modelling.getDescription().getAnnualFrequency();
        if (period == 1) {
            return ProcessingResult.Unprocessed;
        }
        if (this.fixSeasonalRoots(modelling)) {
            log.remark(SEAS_UNDERDIFF);
            return ProcessingResult.Changed;
        }
        if (!this.isUnderDiff(modelling, context)) {
            return ProcessingResult.Unchanged;
        }
        RegSarimaModelling scontext = this.buildNewModel(modelling);
        ModelComparator cmp = ModelComparator.builder().build();
        if (cmp.compare(scontext, modelling) < 0) {
            this.transferInformation(scontext, modelling);
            log.remark(SEAS_UNDERDIFF);
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    private boolean isUnderDiff(RegSarimaModelling modelling, TramoContext context) {
        DoubleSeq res = modelling.getEstimation().getConcentratedLikelihood().e();
        SeasonalityTests tests = SeasonalityTests.residualSeasonalityTest((DoubleSeq)res, (int)modelling.getDescription().getAnnualFrequency());
        return tests.getScore() > 1 || tests.getScore() == 1 && context.seasonal;
    }

    private RegSarimaModelling buildNewModel(RegSarimaModelling context) {
        ModelDescription ndesc = ModelDescription.copyOf((ModelDescription)context.getDescription());
        SarimaOrders spec = ndesc.specification();
        spec.setBp(0);
        spec.setBd(1);
        spec.setBq(1);
        ndesc.setSpecification(spec);
        ndesc.setMean(false);
        RegSarimaModelling ncontext = RegSarimaModelling.of((ModelDescription)ndesc);
        if (!this.estimate(ncontext, false)) {
            return null;
        }
        return ncontext;
    }

    private boolean fixSeasonalRoots(RegSarimaModelling context) {
        ModelDescription description = context.getDescription();
        SarimaModel model = description.arima();
        SarimaOrders spec = model.orders();
        if (spec.getBd() != 0 || spec.getBp() != 1 || model.bphi(1) >= -0.91) {
            return false;
        }
        spec.setBp(0);
        spec.setBd(1);
        spec.setBq(1);
        ModelDescription ndesc = ModelDescription.copyOf((ModelDescription)description);
        ndesc.setSpecification(spec);
        ndesc.setMean(false);
        RegSarimaModelling ncontext = RegSarimaModelling.of((ModelDescription)ndesc);
        if (!this.estimate(ncontext, false)) {
            return false;
        }
        this.transferInformation(ncontext, context);
        return true;
    }
}

