/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import org.vikamine.kernel.Describable;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.util.IdentityLongDescriber;
import org.vikamine.kernel.util.VKMUtil;

public class SupportingFactor
implements Describable {
    private final SGNominalSelector selector;
    private final double shareInPositives;
    private final double negShareInPositives;
    private final double shareInNegatives;
    private final double negShareInNegatives;
    private final double correlationCoefficient;

    public SupportingFactor(SGNominalSelector selector, double shareInPositives, double negShareInPositives, double shareInNegatives, double negShareInNegatives, double correlationCoefficient) {
        this.selector = selector;
        this.shareInPositives = shareInPositives;
        this.negShareInPositives = negShareInPositives;
        this.shareInNegatives = shareInNegatives;
        this.negShareInNegatives = negShareInNegatives;
        this.correlationCoefficient = correlationCoefficient;
    }

    public SGNominalSelector getSelector() {
        return this.selector;
    }

    public double getShareInNegatives() {
        return this.shareInNegatives;
    }

    public double getShareInPositives() {
        return this.shareInPositives;
    }

    public double getNegShareInNegatives() {
        return this.negShareInNegatives;
    }

    public double getNegShareInPositives() {
        return this.negShareInPositives;
    }

    public String getStatisticsString() {
        return String.valueOf(this.shareInPositives) + "/" + this.negShareInPositives + ", " + this.shareInNegatives + "/" + this.negShareInNegatives;
    }

    public String getCorrelationString() {
        double qps = ScoreStatistics.computeQPS(this.correlationCoefficient, (int)this.getShareInPositives(), (int)this.getNegShareInPositives(), (int)this.getShareInNegatives(), (int)this.getNegShareInNegatives());
        String scoreVerbalization = VKMUtil.getFormattedDoubleString(qps);
        return " [" + scoreVerbalization + "]";
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public String getId() {
        return String.valueOf(this.getSelector().getId()) + " (" + this.getCorrelationString() + ") " + this.getStatisticsString();
    }

    @Override
    public String getDescription() {
        return this.getDescription(new IdentityLongDescriber());
    }

    public String getFactorDescription() {
        return this.getSelector().getDescription();
    }

    @Override
    public String getDescription(Describer d) {
        return String.valueOf(d.createDescription(this.getSelector())) + " " + this.getCorrelationString() + " " + this.getStatisticsString();
    }

    public boolean isPositivelyCorrelated() {
        return this.correlationCoefficient > 0.0;
    }

    private static class ScoreStatistics {
        private ScoreStatistics() {
        }

        private static double computeFAR(int fp, int tn) {
            if (fp == 0 && tn == 0) {
                return 1.0;
            }
            return (double)fp / (double)(fp + tn);
        }

        public static double computePositiveQPS(int tp, int fp, int tn) {
            double precision = ScoreStatistics.computePrecision(tp, fp);
            double far = ScoreStatistics.computeFAR(fp, tn);
            return precision * (1.0 - far);
        }

        public static double computeNegativeQPS(int tp, int fp, int tn) {
            double precision = ScoreStatistics.computePrecision(tp, fp);
            double far = ScoreStatistics.computeFAR(fp, tn);
            return precision * (1.0 - far);
        }

        public static double computeQPS(double correlationCoefficient, int tp, int fp, int fn, int tn) {
            if (correlationCoefficient < 0.0) {
                return -1.0 * ScoreStatistics.computeNegativeQPS(fp, tp, fn);
            }
            return ScoreStatistics.computePositiveQPS(tp, fp, tn);
        }

        private static double computePrecision(int tp, int fp) {
            return (double)tp / (double)(tp + fp);
        }
    }
}

