\name{hessian.ffnet}
\title{Evaluate the Hessian for a Trained Single--Hidden--Layer Neural Network}
\usage{
hessian (nn, x, y, errfunc = "SSE", regularizer = "NOR", regc = 1.0) 
}
\alias{hessian}
\alias{hessian.ffnet}
\arguments{
  \item{nn}{an object of class \code{"ffnet"}.}
  \item{x, y}{a vector, matrix, or data frame of input and target examples.}
  \item{errfunc}{a string which specifies the type of objective
    function for the fit. Currently implemented \code{"SSE"} for the
    sum of squared errors, \code{"MAD"} for the mean absolute deviation,
    \code{"GSSE"} for the generalized sum of squared errors,
    and \code{"ENTROPY"}. Note that the latter can be used only together
    with softmax units and vice versa.}
  \item{regularizer}{specifies the type of regularization.
    \code{"NOR"} for no regularization, \code{"WDR"} for weight decay (ridge
    regression), and \code{"LASSO"} for the least absolute shrinkage and
    selection operator (Laplace prior distribution).}
  \item{regc}{the hyper parameter for the regularizer.}
}
\description{
  Evaluates the Hessian matrix of the objective function \code{errfunc}
  plus the regularizer \code{regularizer} for given examples \code{x}
  and \code{y} with respect to the weights (parameters) of
  the trained single-hidden-layer neural network \code{nn}.
}
\details{
  This generic procedure calls routines from a C/C++ library.

  The Hessian is computed by numerically differentiate the
  gradient vector. This may be quite slow for a large Hessian matrix. 

  Missing values are not allowed.
}
\value{
  the Hessian matrix.
}
\seealso{
  \code{\link{ffnet}}, \code{\link{predict.ffnet}},
  \code{\link{print.ffnet}}, \code{\link{fitted.ffnet}},
  \code{\link{residuals.ffnet}}, \code{\link{plot.ffnet}},
  \code{\link{coef.ffnet}}, \code{\link{print.summary.ffnet}}
}
\references{
  C.M. Bishop (1995): \emph{Neural Networks for Pattern
  Recognition}, Clarendon Press, Oxford.

  A. Trapletti (1999): FFNET: A Fast and Flexible software
  library for single-hidden-layer neural NETworks, unpublished
  report.
}
\author{A. Trapletti}
\examples{
x <- runif (1000, -1, 1)  # Non-linear Regression
y <- x^2 - x^3 +0.1*rnorm(x)
plot (x, y)
rr <- lm (y~x)
summary (rr)
points (x, predict(rr,x), col="red")
nn <- ffnet (y~x, nhid=1, itmax=100, optim="DFPMIN", shortcut=T, hessian=F)
hh <- hessian (nn, x, y)
hh
points (x, predict(nn,x), col="green")
}
\keyword{nonlinear, neural}







