// Copyright (C) 1997-1999  Adrian Trapletti
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//
// String class
//


#ifndef _STR_HH_
#define _STR_HH_


#include <iostream.h>
#include <string.h>


class str  /* from B.Stroustrup (1994), The C++ Programming Language, 2nd Edition,
	      Addison-Wesley, Reading, MA, 248-251 */
{
  friend istream& operator>> (istream& s, str& x); 
  
  friend ostream& operator<< (ostream& s, const str& x)
  {
    return s << x.p->s;
  }  
  friend int operator== (const str& x, const char* s)
  {
    return strcmp (x.p->s, s) == 0;
  }
  friend int operator== (const str& x, const str& y)
  {
    return strcmp (x.p->s, y.p->s) == 0;
  }
  friend int operator!= (const str& x, const char* s)
  {
    return strcmp (x.p->s, s) != 0;
  }
  friend int operator!= (const str& x, const str& y)
  {
    return strcmp (x.p->s, y.p->s) != 0;
  }

private:
  struct srep
  {
    char* s;  // pointer to data
    int n;    // reference count
    srep () { n = 1; }
  };
  srep* p;

public:
  str ();  // str x;
  str (const char* s);  // str x = "abc"
  str& operator= (const char* s);
  str& operator= (const str& x);
  ~str ();
  char& operator[] (int i);
  const char& operator[] (int i) const;
  char* copy () const;  // copy string into char* and return char*

  str (const str& x) { x.p->n++; p = x.p; }  // str x = str ...
};
  

#endif  // _STR_HH_








