// Copyright (C) 1997-1999  Adrian Trapletti
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//
// Timing utilities
//


#include <iostream.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "timer.hh"


void CPUtime::start ()  // start timer
{
  struct rusage usage;
  
  getrusage (RUSAGE_SELF, &usage);
  u_time = (double)usage.ru_utime.tv_sec+(double)usage.ru_utime.tv_usec/1000000.0;
  s_time = (double)usage.ru_stime.tv_sec+(double)usage.ru_stime.tv_usec/1000000.0;
}

void CPUtime::stop ()  // stop timer
{
  struct rusage usage;
  double u_time_stop, s_time_stop;
  
  getrusage (RUSAGE_SELF, &usage);
  u_time_stop = (double)usage.ru_utime.tv_sec+(double)usage.ru_utime.tv_usec/1000000.0;
  s_time_stop = (double)usage.ru_stime.tv_sec+(double)usage.ru_stime.tv_usec/1000000.0;
  u_time = u_time_stop-u_time;
  s_time = s_time_stop-s_time;
}

ostream& operator<< (ostream& s, const CPUtime& t)  // write timer information to ostream
{
  int old_precision = s.precision(4);
  int old_options = s.flags(ios::fixed);

  s << "timer: " << fabs(t.u_time) << "u " << fabs(t.s_time) << "s " <<  fabs(t.u_time+t.s_time) << "t " << endl;
  s.flags (old_options);
  s.precision (old_precision);
  return s;
}


