#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include "tchar.h"

#ifdef _UNICODE
#include <memory.h>
#else /* !_UNICODE */
#include <ctype.h>
#endif /* _UNICODE */

#ifdef DEBUG
#define DEBUGGING(code) {code;}
#else
#define DEBUGGING(code)
#endif /* DEBUG */

#ifdef MSS
#include "mss.h"
#endif /* MSS */

#define REGISTER register

/*
   ** TODO:
	 **
	 ** - make indipendent from M$ tchar.h (use another tchar.h or the like)
	 ** - it actually compiles only under MSVC (?)
	 ** - make the %-04d format not to add '0'
	 ** - remove the need for BUFSIZE in vxprintf (how)
	 ** - use a custom allocator
	 ** - test vmprintf also
	 ** - implement a real test driver
	 **
   ** $Log: mprintf.c $
   ** Revision 1.2  2000/12/12 00:47:00  federico
   ** Added the _TEXT macro to some characters constants.
   ** Modified some #define'd lengths.
   **
   ** Revision 1.1  2000/12/12 00:23:35  federico
   ** Initial revision
   **
   ** Revision 1.2  2000-12-12 00:21:25+01  federico
   ** First nearly-working version with UNICODE support !
   **
   ** Revision 1.1  2000/11/15 22:33:55  federico
   ** Initial revision
   **
   ** Revision 1.2  1999/11/11 22:21:34  federico
   **
	 **
*/

/* The following copyright notice applies to code generated by
   ** "mktclapp".  The "mktclapp" program itself is covered by the
   ** GNU Public License.
   **
   ** Copyright (c) 1998 D. Richard Hipp
	 ** Copyright (c) 1999 F. Spinazzi
   **
   ** The author hereby grants permission to use, copy, modify, distribute,
   ** and license this software and its documentation for any purpose, provided
   ** that existing copyright notices are retained in all copies and that this
   ** notice is included verbatim in any distributions. No written agreement,
   ** license, or royalty fee is required for any of the authorized uses.
   ** Modifications to this software may be copyrighted by their authors
   ** and need not follow the licensing terms described here, provided that
   ** the new terms are clearly indicated on the first page of each file where
   ** they apply.
   **
   ** In no event shall the author or the distributors be liable to any party
   ** for direct, indirect, special, incidental, or consequential damages
   ** arising out of the use of this software, its documentation, or any
   ** derivatives thereof, even if the author has been advised of the
   ** possibility of such damage.  The author and distributors specifically
   ** disclaim any warranties, including but not limited to the implied
   ** warranties of merchantability, fitness for a particular purpose, and
   ** non-infringment.  This software is provided at no fee on an
   ** "as is" basis.  The author and/or distritutors have no obligation
   ** to provide maintenance, support, updates, enhancements and/or
   ** modifications.
   **
   ** GOVERNMENT USE: If you are acquiring this software on behalf of the
   ** U.S. government, the Government shall have only "Restricted Rights"
   ** in the software and related documentation as defined in the Federal
   ** Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
   ** are acquiring the software on behalf of the Department of Defense, the
   ** software shall be classified as "Commercial Computer Software" and the
   ** Government shall have only "Restricted Rights" as defined in Clause
   ** 252.227-7013 (c) (1) of DFARs.  Notwithstanding the foregoing, the
   ** author grants the U.S. Government and others acting in its behalf
   ** permission to use and distribute the software in accordance with the
   ** terms specified in this license.
 */
/*
   ** The following modules is an enhanced replacement for the "printf" programs
   ** found in the standard library.  The following enhancements are
   ** supported:
   **
   **      +  Additional functions.  The standard set of "printf" functions
   **         includes printf, fprintf, sprintf, vprintf, vfprintf, and
   **         vsprintf.  This module adds the following:
   **
   **           *  mprintf --  Similar to sprintf.  Writes output to memory
   **                          obtained from IDBUG_MALLOC.
   **
   **           *  A v- version (ex: vmprintf) of every function is also
   **              supplied.
   **
   **      +  A few extensions to the formatting notation are supported:
   **
   **           *  The "=" flag (similar to "-") causes the output to be
   **              be centered in the appropriately sized field.
   **
   **           *  The %b field outputs an integer in binary notation.
   **
   **           *  The %c field now accepts a precision.  The character output
   **              is repeated by the number of times the precision specifies.
   **
   **           *  The %' field works like %c, but takes as its character the
   **              next character of the format string, instead of the next
   **              argument.  For example,  printf("%.78'-")  prints 78 minus
   **              signs, the same as  printf("%.78c",'-').
   **
   **      +  When compiled using GCC on a SPARC, this version of printf is
   **         faster than the library printf for SUN OS 4.1.
   **
   **      +  All functions are fully reentrant.
   **
 */
/*
   ** Undefine COMPATIBILITY to make some slight changes in the way things
   ** work.  I think the changes are an improvement, but they are not
   ** backwards compatible.
 */
/* #define COMPATIBILITY       / * Compatible with SUN OS 4.1 */
/*
   ** Characters that need to be escaped inside a TCL string.
 */
static const TCHAR NeedEsc [] =
{
	1, 1, 1, 1, 1, 1, 1, 1, 'b', 't', 'n', 1, 'f', 'r', 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	0, 0, '"', 0, '$', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '[', '\\', ']', 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
};

/*
   ** Conversion types fall into various categories as defined by the
   ** following enumeration.
 */
/* Meschach Machine.h defines FLOAT ! */
#undef FLOAT
enum e_type
	{															/* The type of the format field */
		RADIX,											/* Integer types.  %d, %x, %o, and so forth */
		FLOAT,											/* Floating point.  %f */
		EXP,												/* Exponentional notation. %e and %E */
		GENERIC,										/* Floating or exponential, depending on exponent. %g */
		SIZE,												/* Return number of characters processed so far. %n */
		STRING,											/* Strings. %s */
		PERCENT,										/* Percent symbol. %% */
		CHARX,											/* Characters. %c */
		ERROR,											/* Used to indicate no such conversion type */
/* The rest are extensions, not normally found in printf() */
		CHARLIT,										/* Literal characters.  %' */
		TCLESCAPE,									/* Strings with special characters escaped.  %q */
		MEM_STRING,									/* A string which should be deleted after use. %z */
		ORDINAL											/* 1st, 2nd, 3rd and so forth */
	};

/*
   ** Each builtin conversion character (ex: the 'd' in "%d") is described
   ** by an instance of the following structure
 */
typedef struct s_info
	{															/* Information about each format field */
		int fmttype;								/* The format field code letter */
		int base;										/* The base for radix conversion */
		TCHAR *charset;							/* The character set for conversion */
		int flag_signed;						/* Is the quantity signed? */
		TCHAR *prefix;								/* Prefix on non-zero values in alt format */
		enum e_type type;						/* Conversion paradigm */
	}
info;

/*
   ** The following table is searched linearly, so it is good to put the
   ** most frequently used conversion types first.
 */
static const info fmtinfo[] =
{
	{_TEXT('d'), 10, _TEXT("0123456789"), 1, 0, RADIX,},
	{_TEXT('s'), 0, 0, 0, 0, STRING,},
	{_TEXT('q'), 0, 0, 0, 0, TCLESCAPE,},
	{_TEXT('z'), 0, 0, 0, 0, MEM_STRING,},
	{_TEXT('c'), 0, 0, 0, 0, CHARX,},
	{_TEXT('o'), 8, _TEXT("01234567"), 0, _TEXT("0"), RADIX,},
	{_TEXT('u'), 10, _TEXT("0123456789"), 0, 0, RADIX,},
	{_TEXT('x'), 16, _TEXT("0123456789abcdef"), 0, _TEXT("x0"), RADIX,},
	{_TEXT('X'), 16, _TEXT("0123456789ABCDEF"), 0, _TEXT("X0"), RADIX,},
	{_TEXT('r'), 10, _TEXT("0123456789"), 0, 0, ORDINAL,},
	{_TEXT('f'), 0, 0, 1, 0, FLOAT,},
	{_TEXT('e'), 0, _TEXT("e"), 1, 0, EXP,},
	{_TEXT('E'), 0, _TEXT("E"), 1, 0, EXP,},
	{_TEXT('g'), 0, _TEXT("e"), 1, 0, GENERIC,},
	{_TEXT('G'), 0, _TEXT("E"), 1, 0, GENERIC,},
	{_TEXT('i'), 10, _TEXT("0123456789"), 1, 0, RADIX,},
	{_TEXT('n'), 0, 0, 0, 0, SIZE,},
	{_TEXT('%'), 0, 0, 0, 0, PERCENT,},
	{_TEXT('b'), 2, _TEXT("01"), 0, _TEXT("b0"), RADIX,},	/* Binary notation */
	{_TEXT('p'), 10, _TEXT("0123456789"), 0, 0, RADIX,},	/* Pointers */
	{_TEXT('\''), 0, 0, 0, 0, CHARLIT,},	/* Literal char */
};

/* Size of the fmtinfo table */
#define NINFO  (sizeof(fmtinfo)/sizeof(info))

/*
   ** If NOFLOATINGPOINT is defined, then none of the floating point
   ** conversions will work.
 */
#ifndef NOFLOATINGPOINT
/*
   ** "*val" is a double such that 0.1 <= *val < 10.0
   ** Return the ascii code for the leading digit of *val, then
   ** multiply "*val" by 10.0 to renormalize.
   **
   ** Example:
   **     input:     *val = 3.14159
   **     output:    *val = 1.4159    function return = '3'
   **
   ** The counter *cnt is incremented each time.  After counter exceeds
   ** 16 (the number of significant digits in a 64-bit float) '0' is
   ** always returned.
 */
static int
getdigit (double *val, int *cnt)
{
	int digit;
	double d;
	if ((*cnt)++ >= 16)
		return '0';
	digit = (int) *val;
	d = digit;
	digit += '0';
	*val = (*val - d) * 10.0;
	return digit;
}
#endif

/* This structure is used to store state information about the
   ** write in progress
 */
struct sgMprintf
{
	TCHAR * zBase;									/* A base allocation */
	TCHAR * zText;									/* The string collected so far */
	int nChar;  										/* Length of the string so far */
	int nAlloc;	  									/* Amount of space allocated in zText */
};


/*
   ** The root program.  All variations call this core.
   **
   ** INPUTS:
   **   func   This is a pointer to a function taking three arguments
   **            1. A pointer to the list of characters to be output
   **               (Note, this list is NOT null terminated.)
   **            2. An integer number of characters to be output.
   **               (Note: This number might be zero.)
   **            3. A pointer to anything.  Same as the "arg" parameter.
   **
   **   arg    This is the pointer to anything which will be passed as the
   **          third argument to "func".  Use it for whatever you like.
   **
   **   fmt    This is the format string, as in the usual print.
   **
   **   ap     This is a pointer to a list of arguments.  Same as in
   **          vfprint.
   **
   ** OUTPUTS:
   **          The return value is the total number of characters sent to
   **          the function "func".  Returns -1 on a error.
   **
   ** Note that the order in which automatic variables are declared below
   ** seems to make a big difference in determining how fast this beast
   ** will run.
 */

/*
 * Size of the conversion buffer: this size will affect
 * the maximum width and precision allowed.
 */
#define BUFSIZE 1023
#define FUNC(a,b,c) if (!(*func) (a,b,c)) return -1

static int
vxprintf (int (*func) (const TCHAR *, int, void *),
					void *arg,
					const TCHAR *format,
					va_list ap)
{
	REGISTER const TCHAR *fmt;			/* The format string. */
#ifdef _UNICODE
	REGISTER TCHAR c;								/* Next character in the format string */
#else
	REGISTER int c;								/* Next character in the format string */
#endif
	REGISTER TCHAR *bufpt;					/* Pointer to the conversion buffer */
	REGISTER int precision;				/* Precision of the current field */
	REGISTER int length;					/* Length of the field */
	REGISTER int idx;							/* A general purpose loop counter */
	int count;										/* Total number of characters output */
	int width;										/* Width of the current field */
	int flag_leftjustify;					/* True if "-" flag is present */
	int flag_plussign;						/* True if "+" flag is present */
	int flag_blanksign;						/* True if " " flag is present */
	int flag_alternateform;				/* True if "#" flag is present */
	int flag_zeropad;							/* True if field width constant starts with zero */
	int flag_long;								/* True if "l" flag is present */
	int flag_center;							/* True if "=" flag is present */
	unsigned long longvalue;			/* Value for integer types */
	double realvalue;							/* Value for real types */
	const info *infop;						/* Pointer to the appropriate info structure */
	TCHAR buf[BUFSIZE + 1];				/* Conversion buffer */
	TCHAR prefix;									/* Prefix character.  "+" or "-" or " " or '\0'. */
	int errorflag = 0;						/* True if an error is encountered */
	enum e_type xtype;						/* Conversion paradigm */
	TCHAR *zMem;										/* String to be freed */
	TCHAR *zExtra;									/* Extra memory used for TCLESCAPE conversions */
	const static TCHAR spaces[] =
	_TEXT("                                                                 ")
	_TEXT("                                                                 ");
#define SPACESIZE (sizeof(spaces)-1)
#ifndef NOFLOATINGPOINT
	int exp;											/* exponent of real numbers */
	double rounder;								/* Used for rounding floating point values */
	int flag_dp;									/* True if decimal point should be shown */
	int flag_rtz;									/* True if trailing zeros should be removed */
	int flag_exp;									/* True to force display of the exponent */
	int nsd;											/* Number of significant digits returned */
#endif

	fmt = format;									/* Put in a REGISTER for speed */
	count = length = 0;
	bufpt = NULL;

	for (; (c = (*fmt)) != 0; ++fmt)
		{
			DEBUGGING (
				_ftprintf (stderr, _TEXT("vxprintf: dopo il for: bufpt: %s\n"), bufpt);
				_ftprintf (stderr, _TEXT("           arg->zText: %s\n"),
					((struct sgMprintf *) arg)->zText);
			);
			if (c != _TEXT('%'))
				{
					REGISTER int amt;
					bufpt = (TCHAR *) fmt;
					amt = 1;
					while ((c = (*++fmt)) != _TEXT('%') && c != 0)
						amt++;
					DEBUGGING (
						_ftprintf (stderr, _TEXT("vxprintf: prima di FUNC: bufpt: %s\n"),
					 	 bufpt);
					);
					FUNC (bufpt, amt, arg);
					DEBUGGING (
						_ftprintf (stderr, _TEXT("vxprintf: dopo di FUNC: bufpt: %s\n"),
					 	 bufpt);
					);
					count += amt;
					if (c == 0)
						break;
				}
			if ((c = (*++fmt)) == 0)
				{
					errorflag = 1;
					FUNC (_TEXT("%"), 1, arg);
					count++;
					break;
				}
			/* Find out what flags are present */
			flag_leftjustify = flag_plussign = flag_blanksign =
				flag_alternateform = flag_zeropad = flag_center = 0;
			do
				{
					switch (c)
						{
						case '-':
							flag_leftjustify = 1;
							c = 0;
							break;
						case '+':
							flag_plussign = 1;
							c = 0;
							break;
						case ' ':
							flag_blanksign = 1;
							c = 0;
							break;
						case '#':
							flag_alternateform = 1;
							c = 0;
							break;
						case '0':
							flag_zeropad = 1;
							c = 0;
							break;
						case '=':
							flag_center = 1;
							c = 0;
							break;
						default:
							break;
						}
				}
			while (c == 0 && (c = (*++fmt)) != 0);
			if (flag_center)
				flag_leftjustify = 0;
			/* Get the field width */
			width = 0;
			if (c == _TEXT('*'))
				{
					width = va_arg (ap, int);
					if (width < 0)
						{
							flag_leftjustify = 1;
							width = -width;
						}
					c = *++fmt;
				}
			else
				{
					while (_istdigit (c))
						{
							width = width * 10 + c - _TEXT('0');
							c = *++fmt;
						}
				}
			if (width > BUFSIZE - 10)
				{
					width = BUFSIZE - 10;
				}
			/* Get the precision */
			if (c == _TEXT('.'))
				{
					precision = 0;
					c = *++fmt;
					if (c == _TEXT('*'))
						{
							precision = va_arg (ap, int);
#ifndef COMPATIBILITY
							/* This is sensible, but SUN OS 4.1 doesn't do it. */
							if (precision < 0)
								precision = -precision;
#endif
							c = *++fmt;
						}
					else
						{
							while (_istdigit (c))
								{
									precision = precision * 10 + c - '0';
									c = *++fmt;
								}
						}
					/* Limit the precision to prevent overflowing
					 * buf[] during conversion
					 */
					if (precision > BUFSIZE - 40)
						precision = BUFSIZE - 40;
				}
			else
				{
					precision = -1;
				}
			/* Get the conversion type modifier */
			if (c == 'l')
				{
					flag_long = 1;
					c = *++fmt;
				}
			else
				{
					flag_long = 0;
				}
			/* Fetch the info entry for the field */
			infop = 0;
			for (idx = 0; idx < NINFO; idx++)
				{
					if (c == fmtinfo[idx].fmttype)
						{
							infop = &fmtinfo[idx];
							break;
						}
				}
			/* No info entry found.  It must be an error. */
			if (infop == 0)
				{
					xtype = ERROR;
				}
			else
				{
					xtype = infop->type;
				}
			zExtra = 0;

			/*
			   ** At this point, variables are initialized as follows:
			   **
			   **   flag_alternateform          TRUE if a '#' is present.
			   **   flag_plussign               TRUE if a '+' is present.
			   **   flag_leftjustify            TRUE if a '-' is present or if the
			   **                               field width was negative.
			   **   flag_zeropad                TRUE if the width began with 0.
			   **   flag_long                   TRUE if the letter 'l' (ell) prefixed
			   **                               the conversion character.
			   **   flag_blanksign              TRUE if a ' ' is present.
			   **   width                       The specified field width.  This is
			   **                               always non-negative.  Zero is the default.
			   **   precision                   The specified precision.  The default
			   **                               is -1.
			   **   xtype                       The class of the conversion.
			   **   infop                       Pointer to the appropriate info struct.
			 */
			switch (xtype)
				{
				case ORDINAL:
				case RADIX:
					if (flag_long)
						longvalue = va_arg (ap, long);
					else
						longvalue = va_arg (ap, int);
#ifdef COMPATIBILITY
					/* For the format %#x, the value zero is printed "0" not "0x0".
					   ** I think this is stupid. */
					if (longvalue == 0)
						flag_alternateform = 0;
#else
					/* More sensible: turn off the prefix for octal (to prevent "00"),
					   ** but leave the prefix for hex. */
					if (longvalue == 0 && infop->base == 8)
						flag_alternateform = 0;
#endif
					if (infop->flag_signed)
						{
							if (*(long *) &longvalue < 0)
								{
									longvalue = -*(long *) &longvalue;
									prefix = '-';
								}
							else if (flag_plussign)
								prefix = '+';
							else if (flag_blanksign)
								prefix = ' ';
							else
								prefix = 0;
						}
					else
						prefix = 0;
					if (flag_zeropad && precision < width - (prefix != 0))
						{
							precision = width - (prefix != 0);
						}
					bufpt = &buf[BUFSIZE];
					if (xtype == ORDINAL)
						{
							long a, b;
							a = longvalue % 10;
							b = longvalue % 100;
							bufpt -= 2;
							if (a == 0 || a > 3 || (b > 10 && b < 14))
								{
									bufpt[0] = 't';
									bufpt[1] = 'h';
								}
							else if (a == 1)
								{
									bufpt[0] = 's';
									bufpt[1] = 't';
								}
							else if (a == 2)
								{
									bufpt[0] = 'n';
									bufpt[1] = 'd';
								}
							else if (a == 3)
								{
									bufpt[0] = 'r';
									bufpt[1] = 'd';
								}
						}
					{
						REGISTER TCHAR *cset;	/* Use registers for speed */
						REGISTER int base;
						cset = infop->charset;
						base = infop->base;
						do
							{									/* Convert to ascii */
								*(--bufpt) = cset[longvalue % base];
								longvalue = longvalue / base;
							}
						while (longvalue > 0);
					}
					length = (long) &buf[BUFSIZE] - (long) bufpt;
					length /= sizeof (*bufpt);
					for (idx = precision - length; idx > 0; idx--)
						{
							*(--bufpt) = '0';	/* Zero pad */
						}
					if (prefix)
						*(--bufpt) = prefix;	/* Add sign */
					if (flag_alternateform && infop->prefix)
						{										/* Add "0" or "0x" */
							TCHAR *pre, x;
							pre = infop->prefix;
							if (*bufpt != pre[0])
								{
									for (pre = infop->prefix; (x = (*pre)) != 0; pre++)
										*(--bufpt) = x;
								}
						}
					length = (long) &buf[BUFSIZE] - (long) bufpt;
					length /= sizeof (*bufpt);
					break;
				case FLOAT:
				case EXP:
				case GENERIC:
					realvalue = va_arg (ap, double);
#ifndef NOFLOATINGPOINT
					if (precision < 0)
						precision = 6;			/* Set default precision */
					if (precision > BUFSIZE - 10)
						precision = BUFSIZE - 10;
					if (realvalue < 0.0)
						{
							realvalue = -realvalue;
							prefix = '-';
						}
					else
						{
							if (flag_plussign)
								prefix = '+';
							else if (flag_blanksign)
								prefix = ' ';
							else
								prefix = 0;
						}
					if (infop->type == GENERIC && precision > 0)
						precision--;
					rounder = 0.0;
#ifdef COMPATIBILITY
					/* Rounding works like BSD when the constant 0.4999 is used.  Wierd! */
					for (idx = precision, rounder = 0.4999; idx > 0; idx--, rounder *= 0.1);
#else
					/* It makes more sense to use 0.5 */
					for (idx = precision, rounder = 0.5; idx > 0; idx--, rounder *= 0.1);
#endif
					if (infop->type == FLOAT)
						realvalue += rounder;
					/* Normalize realvalue to within 10.0 > realvalue >= 1.0 */
					exp = 0;
					if (realvalue > 0.0)
						{
							int k = 0;
							while (realvalue >= 1e8 && k++ < 100)
								{
									realvalue *= 1e-8;
									exp += 8;
								}
							while (realvalue >= 10.0 && k++ < 100)
								{
									realvalue *= 0.1;
									exp++;
								}
							while (realvalue < 1e-8 && k++ < 100)
								{
									realvalue *= 1e8;
									exp -= 8;
								}
							while (realvalue < 1.0 && k++ < 100)
								{
									realvalue *= 10.0;
									exp--;
								}
							if (k >= 100)
								{
									bufpt = _TEXT("NaN");
									length = 3;
									break;
								}
						}
					bufpt = buf;
					/*
					   ** If the field type is GENERIC, then convert to either EXP
					   ** or FLOAT, as appropriate.
					 */
					flag_exp = xtype == EXP;
					if (xtype != FLOAT)
						{
							realvalue += rounder;
							if (realvalue >= 10.0)
								{
									realvalue *= 0.1;
									exp++;
								}
						}
					if (xtype == GENERIC)
						{
							flag_rtz = !flag_alternateform;
							if (exp < -4 || exp > precision)
								{
									xtype = EXP;
								}
							else
								{
									precision = precision - exp;
									xtype = FLOAT;
								}
						}
					else
						{
							flag_rtz = 0;
						}
					/*
					   ** The "exp+precision" test causes output to be of type EXP if
					   ** the precision is too large to fit in buf[].
					 */
					nsd = 0;
					if (xtype == FLOAT && exp + precision < BUFSIZE - 30)
						{
							flag_dp = (precision > 0 || flag_alternateform);
							if (prefix)
								*(bufpt++) = prefix;	/* Sign */
							if (exp < 0)
								*(bufpt++) = '0';		/* Digits before "." */
							else
								for (; exp >= 0; exp--)
									*(bufpt++) = getdigit (&realvalue, &nsd);
							if (flag_dp)
								*(bufpt++) = '.';		/* The decimal point */
							for (exp++; exp < 0 && precision > 0; precision--, exp++)
								{
									*(bufpt++) = '0';
								}
							while ((precision--) > 0)
								*(bufpt++) = getdigit (&realvalue, &nsd);
							*(bufpt--) = 0;		/* Null terminate */
							if (flag_rtz && flag_dp)
								{								/* Remove trailing zeros and "." */
									while (bufpt >= buf && *bufpt == '0')
										*(bufpt--) = 0;
									if (bufpt >= buf && *bufpt == '.')
										*(bufpt--) = 0;
								}
							bufpt++;					/* point to next free slot */
						}
					else
						{										/* EXP or GENERIC */
							flag_dp = (precision > 0 || flag_alternateform);
							if (prefix)
								*(bufpt++) = prefix;	/* Sign */
							*(bufpt++) = getdigit (&realvalue, &nsd);		/* First digit */
							if (flag_dp)
								*(bufpt++) = '.';		/* Decimal point */
							while ((precision--) > 0)
								*(bufpt++) = getdigit (&realvalue, &nsd);
							bufpt--;					/* point to last digit */
							if (flag_rtz && flag_dp)
								{								/* Remove tail zeros */
									while (bufpt >= buf && *bufpt == '0')
										*(bufpt--) = 0;
									if (bufpt >= buf && *bufpt == '.')
										*(bufpt--) = 0;
								}
							bufpt++;					/* point to next free slot */
							if (exp || flag_exp)
								{
									*(bufpt++) = infop->charset[0];
									if (exp < 0)
										{
											*(bufpt++) = '-';
											exp = -exp;
										}						/* sign of exp */
									else
										{
											*(bufpt++) = '+';
										}
									if (exp >= 100)
										{
											*(bufpt++) = (exp / 100) + '0';		/* 100's digit */
											exp %= 100;
										}
									*(bufpt++) = exp / 10 + '0';	/* 10's digit */
									*(bufpt++) = exp % 10 + '0';	/* 1's digit */
								}
						}
					/* The converted number is in buf[] and zero terminated. Output it.
					   ** Note that the number is in the usual order, not reversed as with
					   ** integer conversions. */
					length = (long) bufpt - (long) buf;
					length /= sizeof (*bufpt);
					bufpt = buf;

					/* Special case:  Add leading zeros if the flag_zeropad flag is
					   ** set and we are not left justified */
					if (flag_zeropad && !flag_leftjustify && length < width)
						{
							int i;
							int nPad = width - length;
							for (i = width; i >= nPad; i--)
								{
									bufpt[i] = bufpt[i - nPad];
								}
							i = prefix != 0;
							while (nPad--)
								bufpt[i++] = '0';
							length = width;
						}
#endif
					break;
				case SIZE:
					*(va_arg (ap, int *)) = count;
					length = width = 0;
					break;
				case PERCENT:
					buf[0] = '%';
					bufpt = buf;
					length = 1;
					break;
				case CHARLIT:
				case CHARX:
					c = buf[0] = (xtype == CHARX ? va_arg (ap, int) : *++fmt);
					if (precision >= 0)
						{
							for (idx = 1; idx < precision; idx++)
								buf[idx] = c;
							length = precision;
						}
					else
						{
							length = 1;
						}
					bufpt = buf;
					break;
				case STRING:
				case MEM_STRING:
					zMem = bufpt = va_arg (ap, TCHAR *);
					if (bufpt == 0)
						bufpt = _TEXT("(null)");
					length = _tcslen (bufpt);
					if (precision >= 0 && precision < length)
						length = precision;
					break;
				case TCLESCAPE:
					{
						int i, j, n, c, k;
						TCHAR *arg = va_arg (ap, TCHAR *);
						if (arg == 0)
							arg = _TEXT("(NULL)");
						for (i = n = 0; (c = arg[i]) != 0; i++)
							{
								k = NeedEsc[c & 0xff];
								if (k == 0)
									{
										n++;
									}
								else if (k == 1)
									{
										n += 4;
									}
								else
									{
										n += 2;
									}
							}
						n++;
						if (n > BUFSIZE)
							{
								/* WARNING: nude malloc ! */
								bufpt = zExtra = calloc (n, sizeof (TCHAR));
							}
						else
							{
								bufpt = buf;
							}
						for (i = j = 0; (c = arg[i]) != 0; i++)
							{
								k = NeedEsc[c & 0xff];
								if (k == 0)
									{
										bufpt[j++] = c;
									}
								else if (k == 1)
									{
										bufpt[j++] = _TEXT('\\');
										bufpt[j++] = ((c >> 6) & 3) + '0';
										bufpt[j++] = ((c >> 3) & 7) + '0';
										bufpt[j++] = (c & 7) + '0';
									}
								else
									{
										bufpt[j++] = _TEXT('\\');
										bufpt[j++] = k;
									}
							}
						bufpt[j] = 0;
						length = j;
						if (precision >= 0 && precision < length)
							length = precision;
					}
					break;
				case ERROR:
					buf[0] = _TEXT('%');
					buf[1] = c;
					errorflag = 0;
					idx = 1 + (c != 0);
					FUNC (_TEXT("%"), idx, arg);
					count += idx;
					if (c == 0)
						fmt--;
					break;
				}												/* End switch over the format type */
			/*
			   ** The text of the conversion is pointed to by "bufpt" and is
			   ** "length" characters long.  The field width is "width".  Do
			   ** the output.
			 */
			if (!flag_leftjustify)
				{
					REGISTER int nspace;
					nspace = width - length;
					if (nspace > 0)
						{
							if (flag_center)
								{
									nspace = nspace / 2;
									width -= nspace;
									flag_leftjustify = 1;
								}
							count += nspace;
							while (nspace >= SPACESIZE)
								{
									FUNC (spaces, SPACESIZE, arg);
									nspace -= SPACESIZE;
								}
							if (nspace > 0)
								FUNC (spaces, nspace, arg);
						}
				}
			if (length > 0)
				{
					FUNC (bufpt, length, arg);
					count += length;
				}
			if (xtype == MEM_STRING && zMem)
				{
					free (zMem);
				}
			if (flag_leftjustify)
				{
					REGISTER int nspace;
					nspace = width - length;
					if (nspace > 0)
						{
							count += nspace;
							while (nspace >= SPACESIZE)
								{
									FUNC (spaces, SPACESIZE, arg);
									nspace -= SPACESIZE;
								}
							if (nspace > 0)
								FUNC (spaces, nspace, arg);
						}
				}
			if (zExtra)
				{
					free (zExtra);
				}
		}														/* End for loop over the format string */
	return errorflag ? -1 : count;
}																/* End of function */
/*
   ** The following section of code handles the mprintf routine, that
   ** writes to memory obtained from IDBUG_MALLOC().
 */


/* The xprintf callback function. */
static int
mout (const TCHAR *zNewText, int nNewChar, void *arg)
{
	struct sgMprintf *pM = (struct sgMprintf *) arg;
	if (pM->nChar + nNewChar + 1 > pM->nAlloc)
		{
			pM->nAlloc = pM->nChar + nNewChar * 2 + 1;
			if (pM->zText == pM->zBase)
				{
					DEBUGGING (
						fprintf (stderr, "mout: allocating %d bytes\n", pM->nAlloc);
						_ftprintf (stderr, _TEXT("\n"));
					);
					pM->zText = calloc (pM->nAlloc, sizeof (TCHAR));
					if ((pM->zText != NULL) && pM->nChar)
						{
							memcpy (pM->zText, pM->zBase, pM->nChar * sizeof (TCHAR));
						 	DEBUGGING (
								_ftprintf (stderr, _TEXT("mout: pM->zText: %s\n"), pM->zText);
								_ftprintf (stderr, _TEXT("\n"));
							);
						}
				}
			else
				{
					TCHAR * tmp;
					/*
					 * TODO: WARN: realloc
					 */
					tmp = realloc (pM->zText, pM->nAlloc);
					if (tmp != NULL)
						{
							pM->zText = tmp;
						 	DEBUGGING (
								_ftprintf (stderr, _TEXT("mout: pM->zText: %s\n"), pM->zText);
								_ftprintf (stderr, _TEXT("\n"));
							);
						}
					else
						return 0;
				}
		}
	if (pM->zText != NULL)
		{
		 	DEBUGGING (
				_ftprintf (stderr, _TEXT("mout: prima di memcpy: pM->zText: %s, ")
			 		_TEXT("zNewText: %s, pM->nChar: %d\n"), pM->zText, zNewText,
					pM->nChar);
			);
			memcpy (&pM->zText[pM->nChar], zNewText, nNewChar * sizeof (TCHAR));
			pM->nChar += nNewChar;
			pM->zText[pM->nChar] = _TEXT('\0');
		 	DEBUGGING (
				_ftprintf (stderr, _TEXT("mout: dopo memcpy: pM->zText: %s, ")
			 		_TEXT("zNewText: %s, pM->nChar: %d\n"), pM->zText, zNewText,
					pM->nChar);
			);
		}

	return 1;
}

/*
   ** mprintf() works like printf(), but allocations memory to hold the
   ** resulting string and returns a pointer to the allocated memory.
   **
 */
static TCHAR *
mprintf (const TCHAR *zFormat,...)
{
	va_list ap;
	struct sgMprintf sMprintf;
	TCHAR *zNew;
	TCHAR zBuf[256];
	int success;

	sMprintf.nChar = 0;
	sMprintf.nAlloc = sizeof (zBuf);
	sMprintf.zText = zBuf;
	sMprintf.zBase = zBuf;
	va_start (ap, zFormat);
	success = vxprintf (mout, &sMprintf, zFormat, ap);
 	DEBUGGING (
		_ftprintf (stderr, _TEXT("Dopo vxprintf zBuf: %s\n"), zBuf);
		_ftprintf (stderr, _TEXT("\n"));
		);
	va_end (ap);

	if (!(success >= 0))
		return NULL;

	sMprintf.zText[sMprintf.nChar] = 0;
	if (sMprintf.zText == sMprintf.zBase)
		{
			zNew = calloc ((sMprintf.nChar + 1), sizeof (TCHAR));
			if (zNew != NULL)
				_tcscpy (zNew, zBuf);
		}
	else
		{
			TCHAR * tmp= realloc (sMprintf.zText, sMprintf.nChar + 1);
			if (tmp == NULL)
				{
					free (sMprintf.zText);
					return NULL;
				}
			else
				zNew = tmp;
		}

 	DEBUGGING (
		_ftprintf (stderr, _TEXT("Returning zNew: %s\n"), zNew);
		_ftprintf (stderr, _TEXT("\n"));
		);

	return zNew;
}

/*
 * This is the varargs version of mprintf.
 */
static TCHAR *
vmprintf (const TCHAR *zFormat, va_list ap)
{
	struct sgMprintf sMprintf;
	TCHAR zBuf[200];
	sMprintf.nChar = 0;
	sMprintf.zText = zBuf;
	sMprintf.nAlloc = sizeof (zBuf);
	sMprintf.zBase = zBuf;
	vxprintf (mout, &sMprintf, zFormat, ap);
	sMprintf.zText[sMprintf.nChar] = 0;
	if (sMprintf.zText == sMprintf.zBase)
		{
			sMprintf.zText = calloc ((_tcslen (zBuf) + 1), sizeof (TCHAR));
			if (sMprintf.zText)
				_tcscpy (sMprintf.zText, zBuf);
		}
	else
		{
			TCHAR * tmp= realloc (sMprintf.zText, sMprintf.nChar + 1);
			if (tmp == NULL)
				{
					free (sMprintf.zText);
					return NULL;
				}
			else
				sMprintf.zText = tmp;
		}

	return sMprintf.zText;
}

#ifdef TEST
TCHAR *
read_file (TCHAR * file)
{
	FILE * fp;
	TCHAR * text, * base, c;
	int dim;

	fp = _tfopen (file, _TEXT("rb"));
	if (fp == NULL)
		{
			_ftprintf (stderr, _TEXT("cannot open file %s\n"), file);
			return NULL;
		}

	fseek (fp, 0L, SEEK_END);
	dim = ftell (fp);

	fprintf (stderr, "dim of file %s: %d\n", file, dim);

	base = text = calloc ((dim + 1), sizeof (TCHAR));

	if (text == NULL)
		{
			fclose (fp);
			return NULL;
		}

	rewind (fp);
	while (fread (&c, sizeof (c), 1, fp) == 1)
		{
			*text = c;
			text++;
		}
	*text = '\0';

	fclose (fp);


	return base;
}

int
main (int argc, TCHAR ** argv)
{
	TCHAR * text;
	FILE * fp = _tfopen (_TEXT("mprintf._c"), _TEXT("wb"));
	TCHAR * msg = mprintf (_TEXT("mprintf: Ciao %s.\nQuesto e' un test.\nUn numero (%d)."),
		_TEXT("Federico"), 8);
	_putts (msg);
	//_tprintf (_TEXT("La stringa e' lunga %d caratteri\n"), _tcslen (msg));
	free (msg);

#include "tests.c"

	text = read_file (_TEXT("mprintf.c"));
	if (text == NULL)
		abort ();

	msg = mprintf (_TEXT("%s"), text);
	while (*msg)
		{
			fwrite (msg, sizeof (*msg), 1, fp);
			msg++;
		}

	fclose (fp);
	free (text);

	return 0;
}
#endif


