char *foo = "input texinfo @c -*-texinfo-*-"
"@c --------"
"@c $Id$"
"@c "
"@c $Log:$"
"@c --------"
"@c %**start of header"
"@setfilename imem.inf"
"@settitle IMEM"
"@syncodeindex tp cp"
"@syncodeindex fn cp"
"@syncodeindex vr cp"
"@iftex"
"@afourpaper"
"@end iftex"
""
"@c For double-sided printing, uncomment:"
"@c @setchapternewpage odd"
""
"@set EDITION 1.0"
"@set VERSION 1.0"
"@set update-date 1 April 2000"
"@set update-month April 2000"
"@c %**end of header"
""
"@iftex"
"@finalout"
"@end iftex"
""
"@ifinfo"
"@format"
"START-INFO-DIR-ENTRY"
"* IMEM: (imem).             "
"END-INFO-DIR-ENTRY"
"@end format"
""
"@code{IMEM}, an interface to memory management for @code{C} programs."
""
"Copyright @copyright{} 2000 Federico Spinazzi"
""
"Portions Copyright @copyright{} 1997-1999 Kaz Kylheku"
""
"Permission is granted to make and distributed verbatim copies of this"
"manual, provided the copyright notice and this permission notice are"
"preserved on all copies. "
""
"@ignore"
"Permission is granted to process this file throught TeX and print the "
"results, provided the printed document carries copying permission notice "
"identical to this one except for the removal of this paragraph (this "
"paragraph not being relevant to the printed manual)."
""
"@end ignore"
"Permission is granted to copy and distribute modified versions of this"
"manual under the conditions for verbatim copying, provided that the"
"entire resulting derived work is distributed under the terms of a"
"permission notice identical to this one."
""
"Permission is granted to copy and distribute translations of this manual"
"into another language, under the above conditions for modified versions,"
"except that this permission notice may be stated in a translation"
"approved by Federico Spinazzi"
"@end ifinfo"
""
"@titlepage"
"@title IMEM "
"@subtitle Interface to memory management functions."
"@subtitle Edition @value{EDITION}, for IMEM version @value{VERSION} "
"@subtitle @value{update-month}"
"@author by Federico Spinazzi"
""
"@page"
"@vskip 0pt plus 1filll"
"Copyright @copyright{} 2000 Federico Spinazzi"
""
"Portions Copyright @copyright (C) 1997-1999 Kaz Kylheku"
""
"Permission is granted to make and distribute verbatim copies of this"
"manual provided the copyright notice and this permission notice are"
"preserved on all copies."
""
"Permission is granted to copy and distribute modified versions of this"
"manual under the conditions for verbatim copying, provided that the"
"entire resulting derived work is distributed under the terms of a"
"permission notice identical to this one."
""
"Permission is granted to copy and distribute translations of this manual"
"into another language, under the above conditions for modified versions,"
"except that this permission notice may be stated in a translation"
"approved by Federico Spinazzi"
"@end titlepage"
""
"@node Top, License, (dir), (dir)"
"@ifinfo"
"@top IMEM"
" "
"This is edition @value{EDITION} of the IMEM documentation,"
"@w{@value{update-date}}."
""
"@end ifinfo"
""
"@menu"
"* License::                     How @code{IMEM} is licensed"
"* Introduction::                A rationale to @code{IMEM}"
"* Implementation::              Insight into @code{IMEM} implementation"
"* Reference::                   The functions of the interface"
"* Examples::                    Various way to use the library"
"* Index::                       "
""
"@detailmenu"
" --- The Detailed Node Listing ---"
""
"Introduction"
""
"* Applications::                "
"* A crash course::              "
""
"Implementation"
""
"* Rationale::                   "
"* Types and symbols defined::   "
"* Improving and extending @code{IMEM}::  "
""
"Hierarchy of the @code{IMEM} components"
""
"* @code{IMEM} Modules::         "
""
"Types and symbols defined"
""
"* Macros::                      "
"* Types::                       "
"* Constants::                   "
"* Globals::                     "
""
"Types"
""
"* Exception handling related types::  "
"* Generic abstraction types::   "
"* Interfaced functions::        "
"* Allocated memory blocks::     "
"* The actual interface::        "
""
"Constants"
""
"* Initialization constants::    "
"* Other constants::             "
""
"Reference"
""
"* Initialization and deinitialization::  "
"* Memory blocks management::    "
"* Interface information::       "
""
"Examples"
""
"* Non--Warranty::               "
"* Writing and extending applications with @code{IMEM}::  "
"* Using @code{IMEM} in your code::  "
""
"Non--warranty"
""
"* Writing and extending applications with @code{IMEM}::  "
"* Using @code{IMEM} in your code::  "
""
"Writing and extending applications with @code{IMEM}"
""
"* Single Threaded examples::    "
"* Win32 Multiple Threaded examples::  "
""
"Win32 Multiple Threaded examples"
""
"* Win32 - keep going after access violation::  "
"* Win32 - separating the heaps::  "
""
"@end detailmenu"
"@end menu"
""
"@node License, Introduction, Top, Top"
"@comment  node-name,  next,  previous,  up"
"@chapter License"
""
"All rights are reserved by the author, with the following exceptions:"
""
"@itemize @minus"
""
"@item"
"permission is granted to freely reproduce and distribute this software,"
"possibly in exchange for a fee, provided that this copyright notice appears"
"intact;"
""
"@item"
"permission is also granted to adapt this software to produce"
"derivative works, as long as the modified versions carry this copyright"
"notice and additional notices stating that the work has been modified."
""
"@item"
"the source code may be translated into executable form and incorporated"
"into proprietary software; there is no requirement for such software to"
"contain a copyright notice related to this source."
""
"@end itemize"
""
"@node Introduction, Implementation, License, Top"
"@comment  nod-name,  next,  previous,  up"
"@chapter Introduction"
"@cindex multithreading"
"@cindex memory resources"
""
"@code{IMEM} was born in response for a personal need related to the "
"developement of thread--safe libraries in @code{C}."
""
"@code{IMEM} provides a fully run--time customizable interface to"
" memory management functions. The customization include:"
""
"@itemize @bullet"
""
"@item "
"the ability to define allocators and deallocators with additional "
"parameter such as separate heap pointer or other data"
"structures used by your allocator (e.g. pools of fixed size nodes);"
"under some operative systems this can be useful to protect client "
"programs to crash because of troubles with your code;"
""
"@item "
"the ability to define the behaviour related to out of memory "
"conditions, with the upossible use of exceptions (the implementation "
"of the exception stuff was stolen from the @code{KAZLIB} @code{C}"
"library by Kaz Kylheku);"
"this include the excution of user--defined callbacks before resolving"
"the out of memory condition;"
""
"@item "
"the ability to log all the operations;"
""
"@end itemize"
""
"Moreover, @code{IMEM} has the following features:"
"@itemize @bullet"
""
"@item "
"built--in support for ANSI--like memory management, with wrappers for"
"the malloc family;"
""
"@item "
"built--in support for Win32 Heaps;"
""
"@item"
"manage gerarchical memory spaces;"
""
"@item"
"manage static--like workspaces;"
""
"@end itemize"
""
"The @code{IMEM} interface is not a goal per se; instead it is a strongly"
"needed component for my own software developement, based on the idea that"
"I'll never know where my library will be used: it would be a great hit"
"to allow the user to customize it with respect to the most common"
"task: memory management, error handling and reporting, warning messages,"
"progress reports, @dots{}"
""
"Moreover I must warrant the client application that the resources "
"acquired in my library will be returned to the place thay come from, "
"regardless of the condition in wich code is supposed to do it "
"(cancellation request during a lenghty computation, "
"non local control transfer because of an occuring exception and so on)."
""
"One of the goal of the @code{IMEM} interface is to "
"build tools that will allow programmers to bring their algorithms to "
"be high--quality, user--friendly, better used, applications or"
"extensions to existing programs (gasp!). "
""
""
"@menu"
"* Applications::                "
"* A crash course::              "
"@end menu"
""
"@node Applications, A crash course, Introduction, Introduction"
"@comment  node-name,  next,  previous,  up"
"@section Where @code{IMEM} could prove to be useful"
"@cindex win32"
"@cindex heap access serialization"
""
"@code{IMEM} was designed with the following situations in mind:"
""
"@itemize @bullet"
""
"@item"
"development of @code{C} libraries regardless of the computing"
"environment (operative system, user interface, error handling schemes) "
"where they would be used;"
""
"@item"
"resource management, with special care to multithreaded applications"
"where one thread, could signal the others to stop their jobs;"
"notice however that @code{IMEM} can't help you with threads manipulation as it knows nothing"
"about threads;"
""
"@item"
"monitoring memory allocations, also for debugging purpouses"
"(even if it would be better to use the @code{C/C++ MSS} library"
"@footnote{You can find this library at the Simtelnet archives, "
"under the @code{djgpp/v2} directories. See @code{www.delorie.com/djgpp/}"
"for information regarding the @code{djgpp} compiler}, written for debuging memory usage."
""
"@item"
"the implementation of reentrant interpreters;"
""
"@item"
"speeding of programs using many allocations/deallocations @footnote{under some"
"cases, because @code{IMEM} could slow down your up to 600%,"
"@code{:-(} if you want to keep track of the allocated memory blocks @dots{}}."
"As an example, consider what memory allocation is under Win32 (and"
"probably under others operative systems supporting multi--threading) "
"the access to the process heap is serialized by the operating system "
"because the former is shared between threads. "
"As the thread--switching could happen at any time, it is "
"important that, at every execution step, "
"only one thread is acquiring or releasing resources from the heap, "
"in order to always leave them in a consistent state: this requires"
"a thread--sincronization (serialization) scheme, that slow the access to the "
"heap and requires implicit manipulation of kernel data--structures. "
"The @code{HeapCreate} Win32 function allow one to create other heaps, "
"whose access is not serialized: there can be so a significant speedup "
"(@xref{Interfaced functions}.) with the heap access (up to 50% i think)."
""
"@item"
"development of software to be integrated with existing "
"programs (e.g. extension to the wonderfull @code{R} statistical program, "
"to the @code{GRASS} Geographical Information system, plugins for"
"Web--browsers, Relational Database Managers, etc @dots{}."
"@end itemize"
""
"In the following @code{IMEM} will indicate the library and @code{IMEM} "
"interface will indicate the main data structure used to actually "
"implement @code{IMEM}."
""
"@node A crash course,  , Applications, Introduction"
"@comment  node-name,  next,  previous,  up"
"@section A crash course"
""
"In this section a brief tour of @code{IMEM} is made."
""
"@node Implementation, Reference, Introduction, Top"
"@comment  node-name,  next,  previous,  up"
"@chapter Implementation"
"@cindex implementation"
"@cindex hash table"
"@cindex exception handling"
""
"In this chapter the current implementation of @code{IMEM} is described: "
"nothing prevents from implementing it in a better way: I really hope"
"that @code{IMEM} will be useful and made better by all the people"
"that eventually used it."
""
"@menu"
"* Rationale::                   "
"* Types and symbols defined::   "
"* Improving and extending @code{IMEM}::  "
"@end menu"
""
"@node Rationale, Types and symbols defined, Implementation, Implementation"
"@comment  node-name,  next,  previous,  up"
"@section Rationale behind the current implementation"
""
"There are a number of considerations taken in account in the current "
"@code{IMEM} implementation:"
""
"@itemize @bullet"
"@item"
"the compiler you are using produces 32--bit code (I can't guess what"
"happen with 64--bit @code{int}s)."
""
"@item "
"the interfaced allocator will never return the same address twice,"
"before the memory referring to that address"
"hasn't been passed to the corresponding deallocator; that"
"probably means that each interface should be coupled with a"
"specific heap, usually the only heap your program can access."
""
"There is an exception to this rule, i.e. when the allocator"
"returns the same address twice after a request of a zero--bytes"
"block, like the following: "
"@vindex IMEM_WITH_ZB"
"@example "
"#include <stdlib.h>"
""
"int main (void) "
"@{ "
"   char * p ; "
"   p = malloc (0) ;  /* p = 0x001341D0, e.g. */"
"   p = malloc (1) ;  /* idem: memory will leak? */"
"   free (p) ;"
"   return 0; "
"@} "
"@end example"
"In such cases, @code{IMEM} will ignore the allocation of the "
"zero--dimensioned memory block, if properly initialized, "
"(i.e. using the @code{IMEM_WITH_ZB} flag)"
"even it is not so to me clear if it is a memory leak to ignore such blocks."
""
"@item"
"The interfaced @code{realloc}--like function should behave as the"
"ANSI C @code{realloc}; In particular, when reallocating a"
"non--@code{NULL} pointer, previousy obtained from a call to "
"@code{malloc/calloc/realloc} to a dimension of zero "
"bytes, the memory associated with it will be considered as deallocated;"
"in practice the call (with p != NULL):"
"@example"
"realloc (p, 0);"
"@end example"
"will be taken has the have the same effects on @code{p} of the call:"
"@example"
"free (p);"
"@end example"
"@end itemize"
""
"@section Hierarchy of the @code{IMEM} components"
"@cindex hash table"
"@cindex memory block"
"@cindex @code{KAZLIB}"
"@cindex exception handling"
""
"The implementation of @code{IMEM} dues very much to the work"
"of Kaz Kylheku (@email{kaz@@ashi.footprints.net}), who wrote the "
"@code{KAZLIB} library of container algorithms and data structures"
" for @code{C} programming."
"As his code is very fine and well documented, it was a lot easier to "
"implement @code{IMEM}."
""
"@code{IMEM} actually is client of two component of the original "
"@code{KAZLIB} library: the exception--handling and the hash table modules."
"The exception--handling is used to allow to throw exceptions on out "
"of memory conditions; the hash table is used to (efficiently?) keep "
"track of the allocated blocks."
"@footnote{@code{KAZLIB} implements also container for "
"linked--lists and dictionaries but they aren't used by @code{IMEM}.}"
""
"The @code{KAZLIB} code used in @code{IMEM} was modified to support the kind of "
"allocators @code{IMEM} want to interface."
""
"Apart from @code{KAZLIB} I have stolen the implementation of what I"
"think a clever implementation (in @code{C}) of memory pools"
"from the Thomas Niemann (@email{niemann@@yahoo.com}) web "
"pages at @ref{http://members.xoom.com}."
""
"@code{IMEM} has been implemented using information hiding "
"as a primary technique, in order to achieve clarity, simplicity and"
"modularity; it helped me to be more consistent than usual, even if it is"
"not enforced troughout all the code. "
""
"@menu"
"* @code{IMEM} Modules::         "
"@end menu"
""
"@node @code{IMEM} Modules,  , Rationale, Rationale"
"@comment  node-name,  next,  previous,  up"
"@subsection @code{IMEM} Modules"
""
"The modules composing @code{IMEM} are:"
""
"@itemize @minus"
""
"@item"
"@code{hash.c, hash.h}: they cointain the modified @code{KAZLIB} "
"implementation of hash table;"
"@item"
"@code{except.c, except.h}: they cointain the modified @code{KAZLIB} "
"implementation of portable excepption handling in @code{C};"
"@item"
"@code{amb.h}: declaring the types associated to the management "
"of allocated memory blocks;"
"@item"
"@code{pmemfunc.h}: declaring the types of the functions interfaced"
"by @code{IMEM};"
"@item"
"@code{nodepool.c, nodepool.h}: they implement the interface for the "
"management of node--pools; they serve to speed up the allocation of"
"memory blocks of fixed size, typically used by containers, data"
"structures and so on;"
"@item"
"@code{imemdefs.h}: declaring the @code{IMEM} symbols in a "
"namespace--like way: it can be used to customize the prefix for @code{IMEM}"
"functions (default are @code{imem} and @code{IMEM})"
"@item"
"@code{imem.h}: containing the definition of the @code{IMEM} main"
"data structure, the public interface to functions and global"
"variables;"
"@item"
"@code{imem.c}: this module implemens both the functions related"
"to the management of allocated memory blocks and of the @code{IMEM}"
"interface itself; it also contains the @code{IMEM} wrappers for "
"ANSI--like memory management;"
"@item"
"@code{imem_w32.c}: containing wrappers for Win32 heap allocators I have choose"
"@code{HeapAlloc, HeapFree} and so on;"
"@end itemize"
""
""
"@node  Types and symbols defined, Improving and extending @code{IMEM}, Rationale, Implementation"
"@section Types and symbols defined"
""
"@menu"
"* Macros::                      "
"* Types::                       "
"* Constants::                   "
"* Globals::                     "
"@end menu"
""
"@node Macros, Types, Types and symbols defined, Types and symbols defined"
"@subsection Macros"
""
"The following macros are defined to conditionally compile @code{IMEM}"
"modules:"
""
"@itemize @minus"
"@item"
"@code{IMEM_IMPLEMENTATION}"
"@item"
"@code{NDEBUG}"
"@item"
"@code{IMEM_PREFIX/IMEM_UPREFIX}"
"@end itemize"
""
"their are usually unused by the client program;"
""
"@node Types, Constants, Macros, Types and symbols defined"
"@comment  node-name,  next,  previous,  up"
"@subsection Types"
""
"The types defined in @code{IMEM} could be grouped as generic"
"abstraction types, (e.g. @code{I/O}--streams), interfaced "
"function, allocated memory blocks and the actual interface itself."
""
"@menu"
"* Exception handling related types::  "
"* Generic abstraction types::   "
"* Interfaced functions::        "
"* Allocated memory blocks::     "
"* The actual interface::        "
"@end menu"
""
"@node Exception handling related types, Generic abstraction types, Types, Types"
"@unnumberedsubsubsec Exception handling related types"
"@tindex @code{except_t}"
"@c spiega come funziona, dai un esempio, spiega come e' implementata"
""
"The exception--handling stuff is a cosmetic modification of the"
"@code{KAZLIB} implementation. All the work is done by the @code{ANSI}"
"functions @code{setjmp} and @code{longjmp}. The basic principle is the"
"following:"
"a stack of exception--nodes is mantained by the exception--handling"
"interface; the nodes are of two types:"
"@example"
"enum except_stacktype @{"
"  XCEPT_CLEANUP, "
"  XCEPT_CATCHER"
"@};"
"@end example"
"When an exception is thrown, the stack is walked until an"
"exception handler (i.e.: a node of @code{XCEPT_CATCHER} type) "
"is met: at that point a @code{longjmp} will be performed, in order to"
"return control to the code elected to handle it. In the while "
"the functions associated with cleanup"
"nodes (i.e.: nodes of @code{XCEPT_CLEANUP} type) are executed to"
"possibly release resources (e.g.: opened files, allocated memeory) and"
"so on."
"Here we have the two kind of nodes:"
"@example"
"struct except_cleanup @{"
"  void (*except_func) (void *);"
"  void *except_context;"
"@};"
""
"struct except_catch @{"
"  const except_id_t *except_id;"
"  size_t except_size;"
"  except_t except_obj;"
"  jmp_buf except_jmp;"
"@};"
"@end example"
""
"And the main data structure implementing the stack is the following:"
"@example"
"struct except_stacknode @{"
"  struct except_stacknode *except_down;"
"  enum except_stacktype except_type;"
"  union"
"   @{"
"      struct except_catch *except_catcher;"
"      struct except_cleanup *except_cleanup;"
"   @}"
"  except_info;"
"@};"
"@end example"
""
"An exception is thrown by a call to the @code{except_throw} function"
"that processes the exceptions stack as described above."
""
"An exception consist of a compound code:"
"@example"
"typedef struct @{"
"  unsigned long except_group;"
"  unsigned long except_code;"
"@} except_id_t;"
"@end example"
"and of a message:"
"@example"
"typedef struct @{"
"  except_id_t except_id;"
"  const char *except_message;"
"@} except_t;"
"@end example"
" "
"Each handler declares what kind of exception it can handle: exceptions"
"can have a group and a code: the only predefined group is"
"@code{XCEPT_GROUP_ANY}, while the codes are @code{XCEPT_CODE_ANY} and"
"@code{XCEPT_BAD_ALLOC}."
"@c spiega ..."
""
"If an exception is not handled, an 'unhandled exception'"
"handler is called; the exception--nodes stack is infact owned by the"
"following data structure:"
"@example"
"struct except_params @{"
"  void (*uh_catcher_ptr) (except_t *);"
"  struct except_stacknode *top;"
"@};"
"@end example"
""
"@example"
"  except_no_call,"
"  except_call"
"@end example"
""
"@node Generic abstraction types, Interfaced functions, Exception handling related types, Types"
"@comment  node-name,  next,  previous,  up"
"@unnumberedsubsubsec Generic abstraction types"
"@tindex @code{stream_t}"
""
"Currently, there is only one type of abstract data type defined, "
"simply mirroring the @code{C FILE} type:"
"@example"
"typedef FILE stream_t;"
"@end example"
"It is used to access log stream, as logging is (currently) assumed to be  "
"always done to a disk file."
""
"@node Interfaced functions, Allocated memory blocks, Generic abstraction types, Types"
"@comment  node-name,  next,  previous,  up"
"@unnumberedsubsubsec Interfaced functions"
""
"@cindex Windows NT"
"@cindex win32 separate heaps"
"@cindex interfaced functions"
"@cindex interfaced allocator"
"@cindex interfaced reallocator"
"@cindex interfaced deallocator"
"@tindex malloc_t"
"@tindex calloc_t"
"@tindex realloc_t"
"@tindex free_t"
"@tindex imem_deinit_t "
""
""
"The functions interfaced by @code{IMEM} provide an abstract layer to a"
"generic set of memory allocator, similar to those defined in the standard "
"@code{C} run--time library (the @code{malloc} family), with an additional"
"parameter of type @code{void}, plus other utility functions. "
""
"They are accessed via pointer to functions, defined in "
"@code{pmemfunc.h} as follow:"
"@example"
"typedef void * (* imem_malloc_t) (size_t size, void *opaque);"
"typedef void * (* imem_calloc_t) (size_t num, size_t size, void *opaque);"
"typedef void * (* imem_realloc_t)(void * ptr, size_t new_size, void * opaque);"
"typedef void   (* imem_free_t)   (void * ptr, void * opaque);"
"typedef int    (* pdeinit)  (struct private_imem *);"
"@end example"
"The additional parameter is intended to allow the interfaced"
"functions to access their own private data structures. "
""
"As an example, consider the following set of functions from the "
"Win32 @code{API}:"
"@example"
"LPVOID  HeapAlloc    (HANDLE,DWORD,DWORD);"
"LPVOID  HeapReAlloc  (HANDLE,DWORD,LPVOID,DWORD);"
"BOOL    HeapFree     (HANDLE,DWORD,LPVOID);"
"BOOL    HeapDestroy  (HANDLE);"
"@end example"
"In order to interface these functions with @code{IMEM},"
"the @code{HANDLE} parameter should be the @code{HANDLE} returned "
"by @code{HeapCreate}: "
"@example"
"HANDLE  HeapCreate   (DWORD,DWORD,DWORD);"
"@end example"
"In a single--threaded program running under Microsoft Windows NT 4.0 "
"I have found that these memory management functions can be about "
"50% faster than the corresponding ANSI ones. "
"So I decided to use them when initializing the @code{IMEM} interface "
"with @code{imem_init_w32} (@xref{Applications}.)."
""
"@c insert an example of COM allocator"
""
"@node Allocated memory blocks, The actual interface, Interfaced functions, Types"
"@comment  node-name,  next,  previous,  up"
"@unnumberedsubsubsec Allocated memory blocks"
"@cindex @code{amb_t}"
"@tindex private_amb"
"@tindex private_amb_list"
"@tindex hash_t"
"@tindex amb_t"
"@tindex amb_list_t"
"@tindex node_table_t"
"@tindex node_pool_t"
"@vindex IMEM_KEEP_AMB"
""
"Allocated memory blocks are registered whenever the @code{IMEM} interface "
"is initialized with the @code{IMEM_KEEP_AMB} flag active. "
"If the allocator you want to interface may return the same memory address "
"(from the same heap) twice (@xref{Rationale}.) the @code{IMEM} interface"
"bust be initialized with the @code{IMEM_WITH_ZB} flag set too."
""
"Each of the memory block is registered as a type defined by the "
"following structure, wich keeps all the needed information:"
"@example"
"struct private_amb"
"@{ "
"  void * ptr;        /* the pointer to allocated memory */"
"  size_t size;       /* the size of the allocated block */"
"  int how;           /* how the memory was allocated: calloc, "
"                        malloc or realloc */"
"  int mem_space;     /* memory space who owns this block */"
"  char * function;   /* where the allocation took place ... */"
"  int line;          "
"  char * file;       "
"@};"
"@end example"
"A table of registered blocks is owned by the following structure:"
"@example"
"typedef void node_pool_t;"
"typedef hash_t node_table_t;"
""
"struct private_amb_list"
"@{ "
"  node_table_t * table;"
"  node_pool_t _table_node_pool; /* node pool for the hash table */"
"  node_pool_t * table_node_pool;"
"  node_pool_t _node_pool;     /* node poll for memory blocks */"
"  node_pool_t * node_pool;"
"@};"
"@end example"
"As you can see the @code{node_table_t} is an @code{hash_t}"
"type, inherited by the @code{KAZLIB} hash table component."
""
"The @code{node_pool} and the @code{use_pool} fields are "
"and are related to the possible use of pool of "
"memory blocks (i.e. chunks of equally--sized blocks of "
"memory allocated and deallocated as a whole in order to"
"prevent heap fragmentation and limit the number of system calls) for the"
"amb_list_t data structure. "
""
"@c The @code{glib} library has a module, implementing memory chunks,"
"@c that can be used)"
""
"The @code{IMEM} implementation can access the fields of such structure, "
"as it defines the macro @code{IMEM_IMPLEMENTATION} and can see the"
"following code:"
"@example"
"typedef struct private_amb amb_t;"
"typedef struct private_amb_list amb_list_t;"
"@end example"
"Code that doesn' define @code{IMEM_IMPLEMNTATION} cannot access that "
"information, even if it is still possible access their size"
"@footnote{I'm on thin ice here: does structure alignement matters,"
"if using different compilers, for example with a shared library?}:"
"@example"
"typedef struct @{"
"        char foo[sizeof (struct private_amb) / sizeof (char)];"
"@} amb_t;"
""
"typedef struct @{"
"        char foo[sizeof (struct private_amb_list) / sizeof (char)];"
"@} amb_list_t;"
"@end example"
"Even if all the @code{IMEM} implementation can access both the "
"@code{amb_t} and @code{amb_list_t} structure definition, the manipulation of "
"allocated memory blocks is done by the @code{amb_*} "
"functions in @code{imem.c}"
""
"This has been done in order to keep the code simple: even if consistency"
"is not broken, it would be probably better to define an interface for "
"allocated memory blocks, and separate its implementation in"
"another module (@code{amb.c}). I think that I've already reached the"
"critical mass need to make feasible to separate the implemementation of"
"the allocated memory blocks."
""
"@node The actual interface,  , Allocated memory blocks, Types"
"@unnumberedsubsubsec The actual interface"
"@tindex imem_t"
"@tindex imem_funcs_t"
"@tindex private_mem"
"@tindex exceptions"
""
"The types related to the interface  are published by "
"the header files @code{imem.h}. "
""
"The following public structure contains all the @code{IMEM} parameters"
"related to the interfaced memory--management functions:"
"@example"
"typedef struct _imem_funcs_t"
"@{"
"  size_t flags;"
"  malloc_t  pmalloc;"
"  calloc_t  pcalloc;"
"  realloc_t  prealloc;"
"  free_t pfree;"
"  void * opaque;"
"  imem_deinit_t * pdeinit;"
"  unsigned char prob;"
"@} imem_funcs_t;"
"@end example"
"It is usually used in client code to initialize an @code{IMEM} interface."
"It has been introduced in order to keep the @code{imem_init} function"
"simple to call (i.e. with few parameters). Moreover standard "
"@code{imem_funcs_t} variables could be easily created as in:"
"@example"
"static const imem_funcs_t my_imem_interface = @{"
"  IMEM_KEEP_AMB | IMEM_WITH_ZB,"
"  my_malloc, my_calloc, my_free, NULL, NULL, (char)0@};"
"@end example"
""
"The @code{IMEM} interface is defined as follows:"
"@example"
"struct private_imem"
"@{                           "
"  size_t flags;"
"  imem_malloc_t pmalloc;"
"  imem_calloc_t pcalloc;"
"  imem_realloc_t prealloc;"
"  imem_free_t pfree;"
"  void *opaque;           "
"  int (*pdeinit)(struct private_imem *);"
"  amb_list_t _amb_list;"
"  amb_list_t *amb_list;"
"  unsigned char on_failure;"
"  long size;"
"  size_t curr_mem_space;"
"  struct except_params *except_p;"
"  const char * log_stream_name;"
"  stream_t * log_stream;"
"@};"
"@end example"
"@node Constants, Globals, Types, Types and symbols defined"
"@comment  node-name,  next,  previous,  up"
"@subsection Constants"
""
"@menu"
"* Initialization constants::    "
"* Other constants::             "
"@end menu"
""
"@node Initialization constants, Other constants, Constants, Constants"
"@comment  node-name,  next,  previous,  up"
"@unnumberedsubsubsec Initialization constants flags"
"@vindex IMEM_THROW"
"@vindex IMEM_KEEP_AMB"
"@vindex IMEM_USE_POOL"
"@vindex IMEM_WITH_LOG"
"@vindex IMEM_WITH_ZB"
"@vindex IMEM_WITH_CUSTOM_CLEANUP"
"@itemize @minus"
"@item"
"@code{IMEM_THROW}: with this flag set, @code{IMEM} will thrown an"
"exception when memory will be exausted; for a review of exceptions and"
"exception handling with the @code{IMEM} implementation (@xref{Reference}."
"and @ref{Examples}.)."
""
"@item"
"@code{IMEM_KEEP_AMB}: this flag instruct @code{IMEM} to keep a list of"
"the allocated block, in order to monitor memory allocation and deallocation"
"in detail (function, file and line of allocation/deallocation)."
""
"@item"
"@code{IMEM_USE_POOL}: this flag makes @code{IMEM} to use node--pools"
"when registering memory blocks, in order to achieve better performance; "
"the node--pools are actually used to store the entries in the hash table"
"that implements the allocated memory block list;"
"@item"
"@code{IMEM_WITH_LOG}: this flags instruct @code{IMEM} to log all the "
"operation to a disk file;"
"@c TODO: which file ?"
""
"@item"
"@code{IMEM_WITH_ZB}: this flags instruct @code{IMEM} to ignore "
"those memory blocks whose size is equal to zero;"
""
"@item"
"@code{IMEM_RANDOM_FAIL}: this flag set @code{IMEM} to force the allocator"
"and the reallocator to fails at random, with a probability defined by "
"the @code{prob} field in the @code{imem_funcs_t} structure. This may be"
"useful to test the out--of--memory application or library behaviour;"
"the probability with wich the allocator should fail could be set either"
"in the enviromental variable @code{IMEM}, or with a call to "
"@code{imem_set_fail_prob} (@xref{imem_set_fail_prob}.)."
""
"@item "
"@code{IMEM_WITH_CUSTOM_CLEANUP}: this flag set @code{IMEM} to execute an"
"user supplied function of type @code{imem_deinit_t} during"
"deinitialization (in function @code{imem_deinit}). Such a function can perform"
"actions with side effects on the allocated memory blocks (see for"
"example @code{imem_deinit_w32}, so it must tell @code{imem_deinit} if it"
"should perform its own standard cleanup (e.g.: freeing all the allocated memory"
"blocks) returning a value other zero. "
"It is true that @code{imem_deinit}, and other functions where"
"@code{IMEM_IMPLEMENTATION} is defined, can free memory blocks only if the"
"@code{IMEM} interface was initialized with the @code{IMEM_KEEP_AMB} flag"
"set."
"Be aware of the fact that @code{IMEM} has to perform some operations"
"after the cleaup you ask to execute, so cleanup functions are "
"expected to return!."
""
"@end itemize"
""
"See @ref{Reference} and @ref{Examples} about the use of these macros."
""
"@node Other constants,  , Initialization constants, Constants"
"@unnumberedsubsubsec Other constants"
""
"These costants are used "
"@itemize @minus"
""
"@item"
"@code{YES}"
"@item"
"@code{NO}"
"@item"
"@code{OK}"
"@item"
"@code{BY_MALLOC}"
"@item"
"@code{BY_CALLOC}"
"@item"
"@code{BY_REALLOC}"
""
"@end itemize"
""
""
"@node Globals,  , Constants, Types and symbols defined"
"@subsection Globals"
"@vindex imem_global_s"
"@vindex imem_global"
""
"@code{imem.c} declares two globals variables usefull for using"
"@code{IMEM} in programs with a single @code{IMEM} interface (usually but"
"not necessarly single--threaded). The two variables are exported by"
"@code{imem.h} as:"
"@example"
"extern imem_t imem_global_s;"
"extern imem_t *imem_global = &imem_global_s;"
"@end example"
"They are (currently) unused by @code{IMEM}."
""
"@node Improving and extending @code{IMEM},  , Types and symbols defined, Implementation"
"@section Improving and extending @code{IMEM}"
""
"There are a number of features that can be worthwhile to add to"
"@code{IMEM}. Among these I can cite:"
"@itemize @bullet"
""
"@item"
"support for the linux multi-threading enviroment;"
""
"@item"
"support for @code{POSIX} threads;"
""
"@item"
"support for @code{perl}, @code{python} and @code{tcl} allocators;"
""
"@item"
"a @code{C++} wrapper;"
""
"@end itemize"
""
""
"@node Reference, Examples, Implementation, Top"
"@chapter Reference"
""
"@menu"
"* Initialization and deinitialization::  "
"* Memory blocks management::    "
"* Interface information::       "
"@end menu"
""
"@node Initialization and deinitialization, Memory blocks management, Reference, Reference"
"@section Initialization and deinitialization"
""
"Initializetion function @code{imem_init} is intended to always return:"
"surely a non returning allocator can be provided to the interface,"
"but this kind of situation is not managed by @code{IMEM}, which is"
"intended to interface @code{malloc}--like allocators. This way, an out"
"of memory condition should occur during imem_init, you'll get an error"
"code and an error message."
""
"@node Memory blocks management, Interface information, Initialization and deinitialization, Reference"
"@section Memory blocks management"
""
"@node Interface information,  , Memory blocks management, Reference"
"@section Interface information"
""
"imem_malloc"
"imem_calloc"
"imem_realloc"
"imem_free"
"imem_free_mem_space"
"imem_init"
"imem_deinit"
"imem_init_ansi"
"imem_init_w32"
""
""
"@c IMEM_RANDOM_FAIL???_"
""
"@node Examples, Index, Reference, Top"
"@chapter Examples"
""
"@menu"
"* Non--Warranty::               "
"* Writing and extending applications with @code{IMEM}::  "
"* Using @code{IMEM} in your code::  "
"@end menu"
""
"@node Non--Warranty, Writing and extending applications with @code{IMEM}, Examples, Examples"
"@comment  node-name,  next,  previous,  up"
"@section Non--warranty"
"Here I'll try to share my knowledge with you: don't take the discussion"
"and the examples as TRUTH: I cannot warrant anything about them!"
""
"Moreover, if you can make these notes better, please help me and drop me"
"an e-mail at @email{fspinazzi@@hotmail.com}."
""
""
"@menu"
"* Writing and extending applications with @code{IMEM}::  "
"* Using @code{IMEM} in your code::  "
"@end menu"
""
"@node Writing and extending applications with @code{IMEM}, Using @code{IMEM} in your code, Non--Warranty, Examples"
"@section Writing and extending applications with @code{IMEM}"
""
"Here explain the rationale"
""
"@menu"
"* Single Threaded examples::    "
"* Win32 Multiple Threaded examples::  "
"@end menu"
""
"@node Single Threaded examples, Win32 Multiple Threaded examples, Writing and extending applications with @code{IMEM}, Writing and extending applications with @code{IMEM}"
"@subsection Single Threaded examples"
""
"Foo."
""
"@node  Win32 Multiple Threaded examples,  , Single Threaded examples, Writing and extending applications with @code{IMEM}"
"@subsection  Win32 Multiple Threaded examples"
""
"Immagine you have written a beautiful library and you are "
"freely distributing it as a plugin for a free relational database"
"manager (@code{RDBM}) running under Win32 operative systems; "
"you know that it would be a bad thing to have"
"your library to crash a client application and  so you have "
"done much testing and a lot of debugging, but @dots{}"
""
"One day, your code accesses a bad memory address and "
"damages the heap data structures; at this point there two things"
"that could happen:"
""
"@enumerate "
""
"@item"
"a software--exception occurs immediatly: in this case "
"there is a possibility to recover, as at this point the heap data"
"structure shouldn't be corrupted;"
""
"@item"
"the @code{RDBM} silently keep going, because the way Win32 heaps "
"behave and Murphy's Law @dots{}: when an exception will occur it will be"
"too late (I think) because you will not able to recover from an heap"
"corruption;"
""
"@end enumerate"
""
"In either case it would be fine if the bug in your code "
"wouldn't stop the @code{RDBM}: of course there are several "
"ways to extend an applications, but they maybe "
"unfeasible (e.g.: source code not accessible), slower, "
"less challenging and so on."
""
"@menu"
"* Win32 - keep going after access violation::  "
"* Win32 - separating the heaps::  "
"@end menu"
""
"@node  Win32 - keep going after access violation, Win32 - separating the heaps, Win32 Multiple Threaded examples, Win32 Multiple Threaded examples"
"@unnumberedsubsubsec Win32: keep going after access violation"
""
"Here I'll try to show how one can try to recover from an access violation"
"under Win32, using @code{IMEM}: this (simple) example was tested to a limited"
"extent, but I think it is based on the right assumptions (correct me if this"
"is not the case)."
""
"There is a program (in this case it's @code{main}) needing"
"another thread, contained in an external library (@code{FirstTread})"
"to do its job; at the same time the program is looking for something"
"we don't know (@code{SecondThread})."
""
"We have written the library in question and built dinamic library for"
"the program: YUK !"
""
"The program does very few things: start the threads and wait for their exits."
""
"Here's @code{main} (assume @code{assert} is a fine error hanling scheme!):"
"@c chBEGINTHREADX !!!"
"@example"
"int"
"main (int argc, char **argv)"
"@{"
"  HANDLE hThread[THREAD_NUMBER];"
"  DWORD dwThreadId[THREAD_NUMBER];"
""
"  /* "
"   * start the first thread"
"   */"
"  hThread[0] = BEGINTHREADEX (NULL, 0, FirstThread,"
"                                NULL, 0, &dwThreadId[0]);"
""
"  assert (hThread[0] != NULL);"
"  fprintf (stderr, First thread started ...n);"
""
"  /* give me the chance to start only the first thread */"
"  if (argc == 1)"
"    @{"
"      hThread[1] = BEGINTHREADEX (NULL, 0, SecondThread,"
"                                    NULL, 0, &dwThreadId[1]);"
"      assert (hThread[1] != NULL);"
"      fprintf (stderr, Second thread started ...n);"
"      "
"      /*"
"       * wait the jobs ..."
"       */"
"      WaitForMultipleObjects (THREAD_NUMBER, hThread, TRUE, INFINITE);"
"      fprintf (stderr, Closing threads ...n);"
"      "
"      CloseHandle (hThread[1]);"
"    @}"
"  else"
"    @{"
"      WaitForMultipleObjects (THREAD_NUMBER - 1, hThread, TRUE, INFINITE);"
"      fprintf (stderr, Closing threads ...n);"
"      CloseHandle (hThread[0]);"
"    @}"
"  "
"  return 0;"
"@}"
"@end example"
""
"@node  Win32 - separating the heaps,  , Win32 - keep going after access violation, Win32 Multiple Threaded examples"
"@unnumberedsubsubsec Win32: separating the heaps"
"@cindex win32 separate heaps"
""
""
"@node  Using @code{IMEM} in your code,  , Writing and extending applications with @code{IMEM}, Examples"
"@section Using @code{IMEM} in your code"
""
"Here explain how to easily use @code{IMEM} with the ad-hoc macros"
""
""
"@node Index,  , Examples, Top"
"@unnumbered Index"
""
"@printindex cp"
""
"@summarycontents"
"@contents "
"@bye"
""
;