% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM_SFARIMAAdditionalFunctions.R
\name{sfarima.sim}
\alias{sfarima.sim}
\title{Simulation of a \eqn{SFARIMA(p, q, d)}-process}
\usage{
sfarima.sim(n_x, n_t, model)
}
\arguments{
\item{n_x}{Number of simulated observation rows.}

\item{n_t}{Number of simulated observation columns.}

\item{model}{A list containing the coefficient matrices \code{ar} and 
\code{ma} of the QARMA model, the long memory parameter vector \code{d} as
well as the standard deviation of innovations \code{sigma}.}
}
\value{
The function returns an object of class \code{"sfarima"}, consisting
of

 \tabular{ll}{
  \code{Y} \tab A \eqn{n_x \times n_t}{n_x x n_t}-matrix of simulated values
  of the specified SFARIMA process.\cr
  \code{innov} \tab The innovations used for simulation, iid. drawn from a 
   normal distribution with zero mean and variance 
   \eqn{\sigma^2}{(sigma)^2}.\cr
  \code{model} \tab The model used for simulation, inherited from input.\cr
  \code{stnry} \tab An logical variable indicating whether the simulated 
  model is stationary.\cr
}
}
\description{
\code{sfarima.sim} simulates a specified SFARIMA-model
 on a lattice with normally distributed innovations.
}
\section{Details}{

Simulation of a separable spatial fractionally ARIMA process (SFARIMA). This 
function returns an object of class \code{"sfarima"}. The simulated
innovations are created from a normal distribution with specified variance
\eqn{\sigma^2}{sigma^2}.

 see the vignette for further details.
}

\examples{
# See vignette("DCSmooth") for examples and explanation
 
ma <- matrix(c(1, 0.2, 0.4, 0.1), nrow = 2, ncol = 2)
ar <- matrix(c(1, 0.5, -0.1, 0.1), nrow = 2, ncol = 2)
d <- c(0.1, 0.1)
sigma <- 0.5
sfarima_model <- list(ar = ar, ma = ma, d = d, sigma = sigma)

sfarima_sim <- sfarima.sim(100, 100, model = sfarima_model)
surface.dcs(sfarima_sim$Y)

}
\seealso{
\code{\link{qarma.est}}
}
