% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdm.R
\name{mdm}
\alias{mdm}
\title{Mutual Dependence Measures}
\usage{
mdm(X, dim_comp = NULL, dist_comp = FALSE, type = "comp_simp")
}
\arguments{
\item{X}{A matrix or data frame, where rows represent samples, and columns represent variables.}

\item{dim_comp}{The numbers of variables contained by all components in \code{X}.
If omitted, each component is assumed to contain exactly one variable.}

\item{dist_comp}{Logical. If \code{TRUE}, the distances between all components from all samples
in \code{X} will be returned.}

\item{type}{The type of mutual dependence measures, including
\itemize{
  \item \code{asym_dcov}: asymmetric measure \eqn{\mathcal{R}_n} based on distance covariance
    \eqn{\mathcal{V}_n}; 
  \item \code{sym_dcov}: symmetric measure \eqn{\mathcal{S}_n} based on distance covariance
    \eqn{\mathcal{V}_n}; 
  \item \code{comp}: complete measure \eqn{\mathcal{Q}_n} based on complete V-statistics;
  \item \code{comp_simp}: simplified complete measure \eqn{\mathcal{Q}_n^\star} based on
    incomplete V-statistics; 
  \item \code{asym_comp}: asymmetric measure \eqn{\mathcal{J}_n} based on complete measure
    \eqn{\mathcal{Q}_n}; 
  \item \code{asym_comp_simp}: simplified asymmetric measure \eqn{\mathcal{J}_n^\star} based on
    simplified complete measure \eqn{\mathcal{Q}_n^\star}; 
  \item \code{sym_comp}: symmetric measure \eqn{\mathcal{I}_n} based on complete measure
    \eqn{\mathcal{Q}_n}; 
  \item \code{sym_comp_simp}: simplified symmetric measure \eqn{\mathcal{I}_n^\star} based on
    simplified complete measure \eqn{\mathcal{Q}_n^\star}.
}
From experiments, \code{asym_dcov}, \code{sym_dcov}, \code{comp_simp} are recommended.}
}
\value{
\code{mdm} returns a list including the following components:
\item{stat}{The value of the mutual dependence measure.}
\item{dist}{The distances between all components from all samples.}
}
\description{
\code{mdm} measures mutual dependence of all components in \code{X},
where each component contains one variable (univariate) or more variables (multivariate).
}
\examples{
# X is a 10 x 3 matrix with 10 samples and 3 variables
X <- matrix(rnorm(10 * 3), 10, 3)

# assume X = (X1, X2) where X1 is 1-dim, X2 is 2-dim
mdm(X, dim_comp = c(1, 2), type = "asym_dcov")

# assume X = (X1, X2) where X1 is 2-dim, X2 is 1-dim
mdm(X, dim_comp = c(2, 1), type = "sym_dcov")

# assume X = (X1, X2, X3) where X1 is 1-dim, X2 is 1-dim, X3 is 1-dim
mdm(X, dim_comp = c(1, 1, 1), type = "comp_simp")
}
\references{
Jin, Z., and Matteson, D. S. (2017).
  Generalizing Distance Covariance to Measure and Test Multivariate Mutual Dependence.
  arXiv preprint arXiv:1709.02532.
  \url{https://arxiv.org/abs/1709.02532}.
}
