% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biases.R
\name{confounding}
\alias{confounding}
\title{Unmeasured confounding}
\usage{
confounding(..., verbose = FALSE)
}
\arguments{
\item{...}{Other arguments. Not currently used for this function.}

\item{verbose}{Logical. If \code{TRUE}, returns warnings and messages immediately.
Defaults to \code{FALSE} because it is generally used within the \code{\link[=multi_bias]{multi_bias()}}
function, which will print the same messages/warnings.}
}
\value{
Invisibly returns a list with components \code{n} (2, the degree of the
polynomial in the numerator), \code{d} (1, the degree of the polynomial in the
denominator), \code{mess} (any messages/warnings that should be printed for the
user), and \code{bias} ("confounding").
}
\description{
A type of bias. Declares that unmeasured confounding will be a
component of interest in the multi-bias sensitivity analysis. Generally used
within other functions, its output is returned invisibly.
}
\examples{
# returns invisibly without print()
print(confounding())

# Calculate an E-value for unmeasured confounding only
multi_evalue(est = RR(4), biases = confounding())

}
\keyword{multi-bias}
