% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsimulation.R
\name{testsimulation}
\alias{testsimulation}
\title{Simulation in kinship analysis}
\usage{
testsimulation(
  afmatrix,
  ss,
  tdelta,
  adelta3 = NULL,
  adelta9 = NULL,
  pedname = "SimPed",
  stepPI = FALSE,
  mu = 0.002
)
}
\arguments{
\item{afmatrix}{name of allele frequency list, which can be loaded with "EvaluatePanel" function}

\item{ss}{sample size}

\item{tdelta}{distribution of the actual IBD or Jacquard coefficient of the individual pairs, i.e., kappa(0-2) or Delta(1-9), respectively. Which should be input in form of single row of data with c() function. It should be noted that the data should be in order of kappa0 to kappa2 or Delta1 to Delta9.}

\item{adelta3}{distributions of the IBD coefficient of the outbred plaintiff's hypotheses in LR calculation, which should be a data.frame with 3 columns and x rows, where x stood for the number of such LR being calculated. The names of columns should be "k0", "k1" and "k2", and those of rows the name of LRs}

\item{adelta9}{distributions of the Jacquard coefficient of the inbred plaintiff's hypotheses in LR calculation, which should be a data.frame with 9 columns and x rows, where x stood for the number of such LR being calculated. The names of columns should be "D1-D9", and those of rows the name of LRs}

\item{pedname}{name of the real relationship, defaults to "SimPed".}

\item{stepPI}{If TRUE, empirical decreasing model of STR mutation would be taken when paternity index is needed to be calculated, otherwise, mutation rate would be taken as PI if IBS=0 between an alleged PC pair.}

\item{mu}{mutation rate when paternity index is needed to be calculated, defualts to 0.002.}
}
\value{
a data.frame containing multiple columns: relationship, CIBS and multiple log0CLR for each simulation
}
\description{
Simulation and calculation in kinship analysis, in which genotype combinations of two groups of individual pairs with different relationships would be generated, specific likelihood ratio, as well as the CIBS score would be calculated for each pair.
}
\examples{
adelta3<-data.frame(k0=c(0,0.25,0.5),k1=c(1,0.5,0.5),k2=c(0,0.25,0),row.names = c("PC","FS","HS"))
adelta9<-data.frame(D1=0,D2=0,D3=0,D4=0,D5=0.25,D6=0,D7=0.25,D8=0.5,D9=0,row.names = "FIMCpair")
data(FortytwoSTR)
results<-testsimulation(afmatrix = FortytwoSTR[["afmatrix"]],ss = 10000,tdelta = c(0,1,0),
adelta3 = adelta3, adelta9 = adelta9,pedname="PC")


}
