% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/delete.R
\name{delete}
\alias{delete}
\title{Delete Nodes and Relationships}
\usage{
delete(...)
}
\arguments{
\item{...}{A list of entities to delete.}
}
\description{
Delete node or relationship object(s) from the graph.
}
\details{
Nodes with incoming or outgoing relationships cannot be deleted.
All incoming and outgoing relationships need to be deleted before the node can be deleted.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, name = "Alice")
bob = createNode(graph, name = "Bob")

rel = createRel(alice, "WORKS_WITH", bob)

delete(rel)
delete(alice, bob)
}
}

