% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{n.freedom}
\alias{n.freedom}
\title{Freedom sample size}
\usage{
n.freedom(N = NA, sep = 0.95, pstar, se = 1)
}
\arguments{
\item{N}{population size, default = NA (unknown) (scalar or vector of same length as sep)}

\item{sep}{desired population sensitivity (scalar or vector)}

\item{pstar}{specified design prevalence as proportion or integer
(scalar or vector of same length as sep)}

\item{se}{unit sensitivity (scalar or vector of same length as sep)}
}
\value{
vector of sample sizes, NA if N is specified and n>N
}
\description{
Calculates sample size for demonstrating freedom or
  detecting disease using the appropriate method, depending on
  whether or not N provided (hypergeometric if N provided, binomial otherwise),
  assuming imperfect test sensitivity, perfect test specificity
  and representative sampling
}
\examples{
# examples for n.freedom - checked
n.freedom(NA, sep=0.95, pstar=0.01, se=1)
n.freedom(500, sep=0.95, pstar=0.01, se=1)
n.freedom(N=c(100, 500, 1000, 5000, 10000, 100000, NA), sep=0.95, pstar=0.01, se=1)
n.freedom(500, sep=0.95, pstar=0.01, se=c(0.5, 0.6, 0.7, 0.8, 0.9, 0.99, 1))
}
\keyword{methods}

