% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLA.R
\name{repr_pla}
\alias{repr_pla}
\title{PLA representation}
\usage{
repr_pla(x, times = 10, return = "points")
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{times}{the number of important points to extract (default 10)}

\item{return}{what to return? Can be "points" (segments),
places of points (segments) in a vector ("places") or "both" (data.frame).}
}
\value{
the values based on the argument return (see above)
}
\description{
The \code{repr_pla} computes PLA (Piecewise Linear Approximation) representation from a time series.
}
\examples{
repr_pla(rnorm(100), times = 12, return = "both")

}
\references{
Zhu Y, Wu D, Li Sh (2007)
A Piecewise Linear Representation Method of Time Series Based on Feature Points.
Knowledge-Based Intelligent Information and Engineering Systems 4693:1066-1072
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
