% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trees.R
\name{tprTrees}
\alias{tprTrees}
\title{constructor for class tprTrees}
\usage{
tprTrees(
  spp = 1L,
  Dm = list(c(30, 28)),
  Hm = list(c(1.3, 5)),
  Ht = 30,
  sHt = rep(0, length(Ht)),
  inv = NULL,
  Rfn = NULL,
  ...
)
}
\arguments{
\item{spp}{species code, see \code{\link{tprSpeciesCode}}}

\item{Dm}{measurements of diameter along trunk}

\item{Hm}{height of measurements along trunk}

\item{Ht}{tree height}

\item{sHt}{standard deviation of stem height \code{Ht}. Can be 0 if height
was measured without error.}

\item{inv}{indicator (0-5) for inventory to assess taper form; numeric scalar
see \code{\link{FormTariff}}}

\item{Rfn}{function to populate residual variance matrix R}

\item{...}{arguments to be passed to \code{initialize()}}
}
\value{
object of class \code{tprTrees}.
}
\description{
constructor for class tprTrees
}
\details{
constructor for a tprTrees object, includes a check on monotonicity
of the taper curve.
}
\examples{
# just define a tree
tpr <- tprTrees(spp=1, Dm=30, Hm=1.3, Ht=27)
plot(tpr)
# define 2 trees with only dbh
tpr <- tprTrees(spp=c(1,3), Dm=c(30, 35), Hm=c(1.3, 1.3), Ht=c(27, 30))
plot(tpr)
# define 2 trees with several measurement
tpr <- tprTrees(spp=c(1,3), Dm=list(c(30, 28), c(35, 33, 31)),
                Hm=list(c(1.3, 8), c(1.3, 5, 8)), Ht=c(27, 30))
plot(tpr)
# define 2 trees with only dbh and inventory indicator (form)
tpr <- tprTrees(spp=c(1,3), Dm=c(30, 35), Hm=c(1.3, 1.3), Ht=c(27, 30), inv=4)
plot(tpr)
}
