% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTTree.R
\name{makeTTree}
\alias{makeTTree}
\title{Simulate a transmission tree}
\usage{
makeTTree(
  off.r,
  off.p,
  pi,
  w.shape,
  w.scale,
  ws.shape = w.shape,
  ws.scale = w.scale,
  maxTime = Inf,
  nSampled = NA
)
}
\arguments{
\item{off.r}{First parameter of the negative binomial distribution for offspring number}

\item{off.p}{Second parameter of the negative binomial distribution for offspring number}

\item{pi}{probability of sampling an infected individual}

\item{w.shape}{Shape parameter of the Gamma probability density function representing the generation time}

\item{w.scale}{Scale parameter of the Gamma probability density function representing the generation time}

\item{ws.shape}{Shape parameter of the Gamma probability density function representing the sampling time}

\item{ws.scale}{Scale parameter of the Gamma probability density function representing the sampling time}

\item{maxTime}{Duration of simulation (can be Inf)}

\item{nSampled}{Number of sampled individuals (can be NA for any)}
}
\value{
A N*3 matrix in the following format with one row per infected host, first column is time of infection, second column is time of sampling, third column is infector
}
\description{
Simulate a transmission tree
}
