% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTSfunctions.R
\name{PTSestim}
\alias{PTSestim}
\title{PTSestim}
\usage{
PTSestim(m)
}
\arguments{
\item{m}{an object of type \code{PTS} created with \code{PTSmodel}}
}
\value{
The same input object with the appropriate fields
filled in, in particular:
\itemize{
\item p0:       Initial values for parameter search
\item p:        Estimated parameters
\item lambda:   Estimated Box-Cox lambda parameter
\item v:        Estimated innovations (white noise in correctly specified models)
\item yFor:     Forecasted values of output
\item yForV:    Variance of forecasted values of output
}
}
\description{
Estimates and forecasts PTS models
}
\details{
\code{PTSestim} estimates and forecasts a time series using an
a PTS model
}
\examples{
\dontrun{
m1 <- PTSsetup(log(AirPassengers))
m1 <- PTSestim(m1)
}
}
\seealso{
\code{\link{PTSmodel}}, \code{\link{PTSsetup}}, \code{\link{PTSvalidate}},
         \code{\link{PTScomponents}}, \code{\link{PTS}}
}
\author{
Diego J. Pedregal
}
