% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt_vt.R
\name{padding}
\alias{padding}
\title{Padding data to dyadic sample size}
\usage{
padding(x, pad = c("per", "zero", "sym"))
}
\arguments{
\item{x}{A vector or time series containing the data be to decomposed.}

\item{pad}{Method for padding, including periodic, zero and symetric padding.}
}
\value{
A dyadic length (power of 2) vector or time series.
}
\description{
Padding data to dyadic sample size
}
\examples{
x <- rnorm(360)
x1 <- padding(x, pad = "per")
x2 <- padding(x, pad = "zero")
x3 <- padding(x, pad = "sym")
ts.plot(cbind(x, x1, x2, x3), col = 1:4)
}
