% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_node.R
\name{subset_node}
\alias{subset_node}
\title{Extract a subset of node from a bioregion.clusters object}
\usage{
subset_node(clusters, node_type = "sites")
}
\arguments{
\item{clusters}{an object of class \code{bioregion.clusters}.}

\item{node_type}{a \code{character} indicating what types of nodes
("sites" or "species") should be extracted
(\code{node_type = "sites"} by default).}
}
\value{
An object of class \code{bioregion.clusters} with a given node type (sites
or species).
}
\description{
This function extracts a subset of node according to its type (sites or
species) from a bioregion.clusters object containing both types of
nodes (sites and species).
}
\note{
The network clustering functions (prefix \code{netclu_}) may return both types of
nodes (sites and species) when applied on bipartite networks
(argument \code{bipartite}). In this case, the type of nodes returned in the
output can be chosen with the argument \code{return_node_type}. This function
allows to retrieve a particular type of nodes (sites or species) from the
output and modify the return_node_type accordingly.
}
\examples{
net <- data.frame(
  Site = c(rep("A", 2), rep("B", 3), rep("C", 2)),
  Species = c("a", "b", "a", "c", "d", "b", "d"),
  Weight = c(10, 100, 1, 20, 50, 10, 20)
)

clusters <- netclu_louvain(net, lang = "igraph", bipartite = TRUE)

clusters_sites <- subset_node(clusters, node_type = "sites")

}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Boris Leroy (\email{leroy.boris@gmail.com})
}
