% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req_cookiemoster_set.r
\name{req_cookiemonster_set}
\alias{req_cookiemonster_set}
\title{Set cookies from the cookiejar to a httr2 request}
\usage{
req_cookiemonster_set(req, jar = default_jar(), ...)
}
\arguments{
\item{req}{A \link[httr2]{request} object.}

\item{jar}{A character string of the path to the cookie jar (the default is
to use \code{default_jar()} to get a suitable directory).}

\item{...}{not currently used.}
}
\value{
A \link[httr2]{request} object (with cookies).
}
\description{
Adds all cookies for the domain from the jar to a httr2 request.
}
\examples{
\dontshow{if (rlang::is_installed(c("httr2", "webfakes"))) withAutoprint(\{ # examplesIf}
library(httr2)
domain <- url_parse(example_url())$hostname
add_cookies(cookiestring = "snicker=doodle; password=secret", domain = domain)
request(example_url()) |>
  req_url_path("/cookies/set") |>
  req_cookiemonster_set() |>
  req_perform() |>
  resp_body_json()
\dontshow{\}) # examplesIf}
}
