% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCheckFit.R
\name{ctFitCovCheck}
\alias{ctFitCovCheck}
\title{Visual model-fit diagnostics for ctsem fits, optionally split by the mean
of a chosen observed variable.}
\usage{
ctFitCovCheck(fit, cor = FALSE, plot = TRUE, splitby = NULL)
}
\arguments{
\item{fit}{A `ctStanFit` object.}

\item{cor}{Logical; if `TRUE` correlations are analysed instead of covariances.}

\item{plot}{Logical; if `TRUE` (default) a `ggplot2` object (or list of plots) is 
returned. If `FALSE`, the raw `data.table` with diagnostics is returned.}

\item{splitby}{Optional character string giving the variable name on which to split subjects.}
}
\value{
Either a plot/list of plots (default, given by `plot.ctFitCovCheck`) or a `data.table`.
}
\description{
Visual model-fit diagnostics for ctsem fits, optionally split by the mean
of a chosen observed variable.
}
\examples{
\donttest{
ctFitCovCheck(ctstantestfit, cor = TRUE, plot = TRUE)

gg=ctFitCovCheck(ctstantestfit, cor = FALSE, plot = TRUE, splitby = "TI1")
print(gg[[1]]+
ggplot2::ggtitle("Covariance Check for Y1 with all other manifest variables, split by TI1"))
}
}
