% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-dsl.R
\docType{data}
\name{rewrites}
\alias{rewrites}
\title{Object for setting up a transformation pipeline when defining functions}
\format{An object of class \code{foolbox_rewrite_spec} of length 1.}
\usage{
rewrites
}
\description{
Object for setting up a transformation pipeline when defining functions
}
\examples{
# This is a very simple inline function that require we
# provide the function body as it should be inserted.
# For a more detailed version, see the Tutorial vignette.
# For a version that permits partial evaluation, see that vignette.
inline <- function(f, fn, body) {
   body <- substitute(body)
   rewrite(f) \%>\%
     rewrite_with(
         rewrite_callbacks() \%>\%
           add_call_callback(fn, function(expr, ...) body)
     )
}

g <- function(x) x**2
h <- rewrites[inline(g,y**2)] < function(y) y + g(y)
h

}
\keyword{datasets}
