% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-project.R
\name{stat_project}
\alias{stat_project}
\title{Statisitc to project coordinates}
\usage{
stat_project(mapping = NULL, data = NULL, crsfrom = NA, crsto = NA,
  position = "identity", show.legend = TRUE, inherit.aes = TRUE,
  geom = "point", ...)
}
\arguments{
\item{mapping}{A mapping as created by \code{aes()} or \code{aes_string()}}

\item{data}{A \code{Spatial*} object or \code{data.frame}.}

\item{crsfrom}{An object that can be coerced to a CRS using \link{as.CRS}; defaults
to the CRS of the data or lat/lon if that does not exist}

\item{crsto}{An object that can be coerced to a CRS using \link{as.CRS}; defaults to
lat/lon so that the plot can be projected using coord_map()}

\item{position}{Passed on to geom_*}

\item{show.legend}{Logical describing the legend visibility.}

\item{inherit.aes}{Logical describing if aesthetics are inherited}

\item{geom}{For data frames, the geometry to use}

\item{...}{Passed to the geom}
}
\description{
Projects coordinates using rgdal/sp. Takes params
\code{crsfrom} and \code{crsto}, both wrapped in \link{as.CRS}, such that you can
pass an epsg code, a CRS object or \code{NA} to guess the input (will be either lat/lon or
google mercator). If \code{NA}, \code{crsto} is assumed
to be EPSG:4326 (Lat/Lon), so data can be used with \link[ggplot2]{coord_map}.
}
\examples{
# longlake roads df is in UTM zone 20 (epsg:26920)
ggplot(longlake_roadsdf, aes(long, lat)) +
  stat_project(geom = "path", crsfrom = 26920) +
  coord_map()

}

