% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_binseg.R
\name{hcp_binseg}
\alias{hcp_binseg}
\title{Binary segmentation (BinSeg) method}
\usage{
hcp_binseg(Q = 2)
}
\arguments{
\item{Q}{The maximum number of change-points to search for using the BinSeg method}
}
\value{
\code{hcp_binseg} object
}
\description{
Change-point detection method that focus on identify change points in mean/variance \url{doi:10.2307/2529204}.
It wraps the BinSeg implementation available in the changepoint library.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_changepoints)

#Using simple example
dataset <- examples_changepoints$simple
head(dataset)

# setting up change point method
model <- hcp_binseg()

# fitting the model
model <- fit(model, dataset$serie)

# execute the detection method
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
