% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.MarginalResponse}
\alias{plot.MarginalResponse}
\title{Show marginal response curves.}
\usage{
\method{plot}{MarginalResponse}(x, target_var = NA, smooth_span = 0.3, ...)
}
\arguments{
\item{x}{(\code{MarginalResponse}) The marginal response curve object to plot.
It could be the return of function \code{\link{marginal_response}}.}

\item{target_var}{(\code{vector} of \code{character}) The target variable to plot. It could be
\code{NA}. If it is \code{NA}, all variables will be plotted.}

\item{smooth_span}{(\code{numeric}) The span value for smooth fit in \code{ggplot2}.
When it is \code{0}, no smooth applied. The default is \code{0.3}.}

\item{...}{Not used.}
}
\value{
\code{ggplot2} figure of response curves
}
\description{
Plot marginal response curves using ggplot2 by optionally set
target variable(s).
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

marginal_responses <- marginal_response(
  model = mod$model,
  var_occ = mod$vars_train,
  variables = mod$variables)
plot(marginal_responses, target_var = 'bio1')
}

}
\seealso{
\code{\link{marginal_response}}
}
