% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{setNoiseLevels}
\alias{setNoiseLevels}
\title{A function for setting and plotting noise levels.}
\usage{
setNoiseLevels(
  mrbinObject,
  plotOnly = FALSE,
  showSpectrumPreview = NULL,
  silent = FALSE
)
}
\arguments{
\item{mrbinObject}{An mrbin object}

\item{plotOnly}{Should only noise plots be generated (TRUE), or should noise levels be adjusted interactively (FALSE)}

\item{showSpectrumPreview}{Should plots be shown? If not provided, this value will be taken from the mrbin object parameters}

\item{silent}{If set to TRUE, plots will not be shown but might still be saved}
}
\value{
An invisible mrbin object
}
\description{
This function reads parameters from the global variable mrbin.env$mrbin$parameters and
plots exemplary spectra and respective noise levels. Plots will be saved if saveFiles is set to "Yes".
}
\examples{
 mrbinObject<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,tryParallel=FALSE,
                   NMRfolders=c(system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/3/10/pdata/10",package="mrbin"))
                   ))
 mrbinObject<-setNoiseLevels(mrbinObject,plotOnly=TRUE)
}
