% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R
\docType{methods}
\name{totals}
\alias{totals}
\alias{get_totals}
\alias{get_totals-method}
\alias{set_totals<-}
\alias{set_totals-method}
\alias{get_totals,CompositionMatrix-method}
\alias{set_totals<-,CompositionMatrix-method}
\alias{set_totals,CompositionMatrix-method}
\title{Row Sums}
\usage{
get_totals(x)

set_totals(x) <- value

\S4method{get_totals}{CompositionMatrix}(x)

\S4method{set_totals}{CompositionMatrix}(x) <- value
}
\arguments{
\item{x}{An object from which to get or set \code{totals}.}

\item{value}{A possible value for the \code{totals} of \code{x}.}
}
\value{
\itemize{
\item \code{set_totals()} returns an object of the same sort as \code{x} with the new
row sums assigned.
\item \code{get_totals()} returns the row sums of \code{x}.
}
}
\description{
Retrieves or defines the row sums (before closure).
}
\examples{
## Create a count matrix
A1 <- matrix(data = as.numeric(sample(1:100, 100, TRUE)), nrow = 20)

## Coerce to compositions
B <- as_composition(A1)

## Row sums are internally stored before coercing to relative frequencies
get_totals(B)

## This allows to restore the source data
A2 <- as_amounts(B)

## Coerce to a data.frame
X <- data.frame(B)
head(X)
}
\seealso{
Other mutators: 
\code{\link{groups}},
\code{\link{identifiers}},
\code{\link{samples}},
\code{\link{split}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
