/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.diff.ElementDiff;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.DoubleDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;

@TestClass(value="org.openscience.cdk.tools.diff.IsotopeDiffTest")
public class IsotopeDiff {
    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = IsotopeDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IIsotope) || !(second instanceof IIsotope)) {
            return null;
        }
        IIsotope firstElem = (IIsotope)first;
        IIsotope secondElem = (IIsotope)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("IsotopeDiff");
        totalDiff.addChild(IntegerDifference.construct("MN", firstElem.getMassNumber(), secondElem.getMassNumber()));
        totalDiff.addChild(DoubleDifference.construct("EM", firstElem.getExactMass(), secondElem.getExactMass()));
        totalDiff.addChild(DoubleDifference.construct("AB", firstElem.getNaturalAbundance(), secondElem.getNaturalAbundance()));
        totalDiff.addChild(ElementDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

