% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followers.R
\name{get_followers}
\alias{get_followers}
\title{get_followers}
\usage{
get_followers(user, n = 75000, page = "-1", parse = TRUE,
  as_double = FALSE, token = NULL)
}
\arguments{
\item{user}{Screen name or user id of target user.}

\item{n}{Number of followers to return. For max return, enter
\code{n = "all"} or \code{n = 75000} (max per token).}

\item{page}{Default \code{page = -1} specifies first page of json
results. Other pages specified via cursor values supplied by
Twitter API response object.}

\item{parse}{Logical, indicating whether to return parsed
vector or nested list (fromJSON) object. By default,
\code{parse = TRUE} saves you the time [and frustrations]
associated with disentangling the Twitter API return objects.}

\item{as_double}{logical indicating whether to handle ID variables
as double (numeric) class. By default, this is set to FALSE, meaning
ID variables are treated as character vectors. Setting this to
TRUE can provide performance (speed and memory) boost but can also
lead to issues when printing and saving, depending on the format.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}
}
\value{
list of follower ids and next page value (presumably
  this would be used in loops extracting more than 75,000
  followers using either multiple tokens or by waiting out
  rate limits)
}
\description{
Returns max followers per token
}
\examples{
\dontrun{
# get ids of users following the president of the US
pres <- get_followers(user = "potus")
pres

# get ids of users following the Environmental Protection Agency
epa <- get_followers(user = "epa")
epa
}

}
\seealso{
\url{https://dev.twitter.com/overview/documentation}

Other ids: \code{\link{get_friends}},
  \code{\link{next_cursor}}
}

