% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_mlp.R
\name{ts_mlp}
\alias{ts_mlp}
\title{MLP}
\usage{
ts_mlp(preprocess = NA, input_size = NA, size = NA, decay = 0.01, maxit = 1000)
}
\arguments{
\item{preprocess}{normalization}

\item{input_size}{input size for machine learning model}

\item{size}{number of neurons inside hidden layer}

\item{decay}{decay parameter for MLP}

\item{maxit}{maximum number of iterations}
}
\value{
returns a \code{ts_mlp} object.
}
\description{
Creates a time series prediction object that
uses the Multilayer Perceptron (MLP).
It wraps the nnet library.
}
\examples{
library(daltoolbox)
data(tsd)
ts <- ts_data(tsd$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- ts_mlp(ts_norm_gminmax(), input_size=4, size=4, decay=0)
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
