% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaMutate.R
\name{xegaGaIVAdaptiveMutateGene}
\alias{xegaGaIVAdaptiveMutateGene}
\title{Individually variable adaptive mutation of a gene.}
\usage{
xegaGaIVAdaptiveMutateGene(gene, lF)
}
\arguments{
\item{gene}{A binary gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A binary gene
}
\description{
\code{xegaGaIVAdaptiveMutateGene} mutates a binary gene.
             Two mutation rates (\code{lF$MutationRate()} 
             and \code{lF$MutationRate2()} which is higher than the first)
             are used depending on the relative fitness of the gene.
             \code{lF$CutoffFit} and \code{lF$CBestFitness} are used
             to determine the relative fitness of the gene.
             The rationale is that mutating genes having a low fitness
             with a higher probability rate improves the performance
             of a genetic algorithm, because the gene gets a higher 
             chance to improve.
}
\details{
This principle is a candidate for a more abstract implementation,
         because it applies to all variants of evolutionary algorithms.

         The goal is to separate the threshold code and the 
         representation-dependent part and 
         to combine them in the factory properly.
}
\examples{
parm<-function(x) {function() {return(x)}}
  lFxegaGaGene$BitMutationRate1<-parm(1.0)
  lFxegaGaGene$BitMutationRate2<-parm(0.5)
gene1<-xegaGaInitGene(lFxegaGaGene)
xegaGaDecodeGene(gene1, lFxegaGaGene)
gene<-xegaGaIVAdaptiveMutateGene(gene1, lFxegaGaGene)
xegaGaDecodeGene(gene, lFxegaGaGene)
}
\references{
Stanhope, Stephen A. and Daida, Jason M. (1996)
  An Individually Variable Mutation-rate Strategy for Genetic Algorithms.
  In: Koza, John (Ed.)
  Late Breaking Papers at the Genetic Programming 1996 Conference.
  Stanford University Bookstore, Stanford, pp. 177-185.
  (ISBN:0-18-201-031-7)
}
\seealso{
Other Mutation: 
\code{\link{xegaGaMutateGene}()}
}
\concept{Mutation}
