% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_age}
\alias{compute_age}
\title{Compute time interval between two dates}
\usage{
compute_age(date_start, date_end, unit = c("years", "months", "days"))
}
\arguments{
\item{date_start}{Starting date. Must be a date or datetime object
compatible with lubridate.}

\item{date_end}{Ending date. Must be a date or datetime object
compatible with lubridate.}

\item{unit}{Character string specifying the unit for the result.
Must be one of "years", "months", or "days". Defaults to "years".}
}
\value{
A numeric value representing the time difference in the specified unit.
}
\description{
Calculate the time difference between two dates in specified units
(years, months, or days). Uses lubridate intervals for accurate calculations
across calendar irregularities.
}
\examples{
# Calculate age in years
compute_age(as.Date("1990-01-01"), as.Date("2024-01-01"))

# Calculate age in months
compute_age(as.Date("2023-01-01"), as.Date("2024-01-01"), unit = "months")

# Calculate age in days
compute_age(as.Date("2023-12-01"), as.Date("2024-01-01"), unit = "days")

}
