% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAU.R
\name{RAU}
\alias{RAU}
\title{Rolling Average Uncoupled}
\usage{
RAU(TL, weeks, training_dates)
}
\arguments{
\item{TL}{training load}

\item{weeks}{training weeks}

\item{training_dates}{training dates}
}
\value{
{This function returns the following variables:
\itemize{
\item RAU_chronic: RAU - chronic training load.
\item RAU_acute: RAU - acute training load.
\item RAU_ACWR: RAU - Acute-Chronic Workload Ratio.
}}
}
\description{
Rolling Average Uncoupled
}
\examples{

\dontrun{
# Get old working directory
oldwd <- getwd()

# Set temporary directory
setwd(tempdir())

# Read db
data("training_load", package = "ACWR")

# Convert to data.frame
training_load <- data.frame(training_load)

# Select the first subject
training_load_1 <- training_load[training_load[["ID"]] == 1,  ]

# Calculate ACWR
result_RAU <- RAU(TL = training_load_1$TL,
                   weeks = training_load_1$Week,
                   training_dates = training_load_1$Training_Date)

# set user working directory
setwd(oldwd)
}

}
