% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_model.R
\name{custom_model}
\alias{custom_model}
\alias{update.custom_model}
\title{Custom Model Wrapper}
\usage{
custom_model(formula, data, ...)

\method{update}{custom_model}(object, data, ...)
}
\arguments{
\item{formula}{Formula needed that defines all variables required for the model}

\item{data}{data to update custom model}

\item{...}{Additional variables for update}

\item{object}{Object of type \verb{custom model}}
}
\value{
An object of class \code{custom_model}. \code{custom_model} is a list that
stores the required formula to update the model and the data used to update
the model.
}
\description{
Function to define basic functionality needed for a custom model that does
not fit the general framework of models that align with \link[ADLP]{adlp_component}
}
\details{
Custom model should support the S3 method \code{formula} and \code{update}.
}
\examples{
data("test_claims_dataset")
custom_model <- custom_model(claims~., data=test_claims_dataset)


}
