% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp.R
\name{ahp}
\alias{ahp}
\title{Calculates the AHP}
\usage{
ahp(base, mapeamento, nomes_alternativas)
}
\arguments{
\item{base}{List of paired arrays or excel path containing the properly formatted paired arrays.}

\item{mapeamento}{Vector containing the number of subscriptions of each criteria, from left to right. mapeamento = rep(0,n) n = number of criteria and no subcriteria;
mapeamento = c(1,2) for one subcriteria in criteria 1 anda two subcriteria in criteria 2. If in doubt, see the tutorial vignette.}

\item{nomes_alternativas}{Vector containing the names of the alternatives in your hierarchy,
if not filled returns a vector of LETTERS.}
}
\value{
Table containing the relationships of criteria, subscriptions (If any) and Alternatives Using the AHP system.
}
\description{
Calculates AHP in a list of paired arrays or in a properly formatted excel worksheet stipend.
}
\examples{
x=paste0(letters[3],1:5)
y=c(5,2,7,3,2)
m1=matrix_ahp(x,y)
x=paste0(letters[1],1:3)
y=c(4.4,5.2,3)
m2=matrix_ahp(x,y)
y=c(2,4,3)
m3=matrix_ahp(x,y)
y=c(4.9,5,3.3)
m4=matrix_ahp(x,y)
y=c(4.4,4.2,4.3)
m5=matrix_ahp(x,y)
y=c(5.4,5.2,5.7)
m6=matrix_ahp(x,y)
base=list(m1, m2, m3, m4, m5, m6)
mapeamento = rep(0,5)
nomes_alternativas = paste0(letters[1],1:3)
ahp(base,mapeamento, nomes_alternativas)

#with subcriteria and 3 criteria and 2 alternatives
mapeamento = c(2,0,0) #2 subcriteria in criteria 1 and 0 subcriteria to others
x=paste0(letters[3],1:3) #3 criteria
y=c(5,2,7)
m1=matrix_ahp(x,y) #compare criteria
x=paste0(letters[4],1:2)
y=c(4,6)
m2=matrix_ahp(x,y) # 2 compare 2 subcriteria of criteria 1
x=paste0(letters[1],1:2)
y=c(2,4)
m3=matrix_ahp(x,y) #alternatives for subcriteria 1
y=c(4.9,5)
m4=matrix_ahp(x,y) #alternatives for subcriteria 2
y=c(4.4,4.2)
m5=matrix_ahp(x,y) #alternatives for criteria 2
y=c(5.4,5.2)
m6=matrix_ahp(x,y) ##alternatives for criteria 3
base=list(m1, m2, m3, m4, m5, m6)

nomes_alternativas = paste0(letters[1],1:2)
ahp(base,mapeamento, nomes_alternativas)

#Other mapeamento: criteria 2 with 2 subcriteria

mapeamento = c(0,2,0)
nomes_alternativas = paste0(letters[1],1:2)
ahp(base,mapeamento, nomes_alternativas)

}
\author{
Lyncoln Oliveira and Luciane Ferreira Alcoforado
}
