% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_beta_hat}
\alias{get_beta_hat}
\title{get_beta_hat}
\usage{
get_beta_hat(Y, X, A, n_ind)
}
\arguments{
\item{Y}{phenotype information}

\item{X}{genotype information}

\item{A}{Allele frequency information}

\item{n_ind}{total number of individuals}
}
\value{
A 2x`n_var` matrix of estimated effect size information (first row corresponds to the first phenotype, second row corresponds to the second phenotype)
}
\description{
simulation function: compute effect sizes estimated form linear regression model
}
\examples{
AC <- get_ac_mat(n_var=100)
A <- get_af_mat(AC=AC, n_ind=10000)
X <- get_geno_mat(AC, n_ind=10000)
b <- get_true_beta(n_var=100, c=0.6, pi=0.5, sigma=1, null=TRUE)
Y <- get_pheno_pair(b=b, X=X, r=0.5)
b_hat <- get_beta_hat(Y=Y, X=X, A=A, n_ind=10000)
}
