% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_spirit.R
\name{calc_spirit}
\alias{calc_spirit}
\title{Calculate Daily Religious or Spiritual Experiences (Spirit) Score}
\usage{
calc_spirit(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `spirit`, where `spirit` is the sum score for daily religious or spiritual experiences.
The score is based on responses to six items, with higher values indicating more frequent experiences.
Participants who did not answer all six questions will have NA values.
}
\description{
This function computes a numeric score representing the frequency of daily religious or spiritual experiences.
The score ranges from 6 to 36, with higher scores indicating more frequent daily religious or spiritual experiences.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 6),
  question_concept_id = rep(c(40192401, 40192415, 40192443, 40192471,
                              40192475, 40192498), times = 3),
  answer_concept_id = sample(c(40192487, 40192432, 40192509, 40192459,
                                40192513, 40192484, 40192385, 40192403),
                             18, replace = TRUE)
)

# Compute daily religious or spiritual experiences (Spirit) scores
spirit_scores <- calc_spirit(survey_df)
head(spirit_scores)

}
