% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_partialAPCeffects.R
\name{compute_marginalAPCeffects}
\alias{compute_marginalAPCeffects}
\title{Internal helper to compute marginal APC effects and their
confidence intervals}
\usage{
compute_marginalAPCeffects(dat, model, variable, plot_CI = FALSE)
}
\arguments{
\item{dat}{Dataset containing predicted effects for a grid of all APC
dimensions and covariates used in the model.}

\item{model}{Model fitted with \code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{variable}{One of \code{c("age","period","cohort")}, specifying the
temporal dimension for which the partial effect plots should be created.}

\item{plot_CI}{Indicator if 95\% confidence intervals for marginal APC effects
should be computed. Defaults to FALSE.}
}
\description{
Internal helper function to add lower and upper confidence boundaries
pointwise
}
\details{
If the model was estimated with a log or logit link, the function
automatically performs an exponential transformation of the effect.
}
