% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdIsMF.R
\name{FLM}
\alias{FLM}
\title{Freundlich Linear Model}
\usage{
FLM (ce, qe)
}
\arguments{
\item{ce}{Equilibrium concentration of the adsorbate in the solution}

\item{qe}{Amount adsorbed}
}
\value{
\itemize{
  \item Freundlich Isotherm Linear Model: Model summary
  \item correlation (ce, qe): Correlation between ce and qe
  \item kf: Freundlich constant
  \item 1/n: Freundlich exponent related to adsorption intensity
  \item AIC: Akaike information criterion
  \item AICc: Corrected Akaike information criterion
  \item BIC: Bayesian information criterion
  \item RMSE: Root Mean Squared Error
  \item MSE: Mean Squared Error
  \item MAE: Mean Absolute Error
  \item MAPE: Mean Absolute Percentage Error
  \item Chi.square: Chi-square value
}
}
\description{
This model will fit the adsorption data to the linear form of the Freundlich equation and will give the estimates of the Freundlich parameters, namely "kf" and "1/n" while evaluating the performance efficiency of the linear model of Freundlich through several error functions.
}
\examples{
ce <- c(0.025, 0.04, 0.055, 0.099, 0.139, 0.402, 1.999, 11.336)
qe <- c(17.21, 35.42, 51.238, 72.659, 89.268, 182.21, 345.29, 634.231)
m.fit <- FLM (ce, qe)
}
\references{
\itemize{
\item Giles, C. H. (1973). The history and use of the Freundlich adsorption isotherm. Journal of the Society of Dyers and Colourists, 89(8), 287-291.
\item Datta, S. P., Bhadoria, P. B. S., & Kar, S. (1998). Availability of extractable boron in some acid soils, West Bengal, India. Communications in soil science and plant analysis, 29(15-16), 2285-2306.
\item Roy, A., Manjaiah, K. M., Datta, S. P., Rakshit, D., Barman, M., Ray, P., Golui, D., Raza, M. B., Tigga, P., Mondal, S., Vishwanath, Meena, S., & Meena, P. (2025). Effect of Low-Molecular-Weight Organic Acids and Silicon on Arsenic Adsorption and Desorption in a Paddy Soil of Bengal Delta Plain: Insights from Thermodynamics and Equilibrium Modeling. Water, Air, & Soil Pollution, 236(6), 344.
\item Raza, M. B., Datta, S. P., Golui, D., Barman, M., Ray, P., Upadhyay, D., Mishra, R., Roy, A., & Dash, A. K. (2025). Enhancing soil arsenic immobilization with organic and inorganic amendments: Insights from sorption–desorption study. Environmental Monitoring and Assessment, 197(1), 76.
}
}
