% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{compute.xty}
\alias{compute.xty}
\title{Compute X'y Vector}
\usage{
compute.xty(x, y, robust = 0, k_value = 1.5)
}
\arguments{
\item{x}{Matrix, input data matrix}

\item{y}{Vector, response vector}

\item{robust}{Integer, 0 for classical estimate, 1 for Huber robust estimate}

\item{k_value}{Numeric, tuning parameter for Huber function}
}
\value{
Covariance vector
}
\description{
Compute X'y Vector
}
\examples{
# Create sample data
set.seed(123)
x <- matrix(rnorm(100), 20, 5)
y <- rnorm(20)
x[sample(100, 8)] <- NA  # Missing values in x

# Classical cross-covariance
xty_classical <- compute.xty(x, y, robust = 0)
print(round(xty_classical, 3))

# Robust cross-covariance
xty_robust <- compute.xty(x, y, robust = 1)
print(round(xty_robust, 3))
}
