% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{bet_model}
\alias{bet_model}
\title{BET Isotherm Model}
\usage{
bet_model(Ce, Qe, Cs = max(Ce) * 1.1)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}

  \item{Cs}{Saturation concentration.}
}
\value{
A named list of BET parameters and model details.
}
\description{
The BET isotherm extends the Langmuir theory to multilayer adsorption (Brunauer et al., 1938). It is used
to estimate surface area and porosity of adsorbents. The model is applicable under specific physical or
chemical conditions and is described by the equation:

\deqn{Q = \frac{Q_m \cdot C_b \cdot P}{(P_0 - P) \left(1 + (C_b - 1) \cdot \frac{P}{P_0} \right)}}

where \eqn{Q} is the amount adsorbed, \eqn{P} is the equilibrium pressure, \eqn{P_0} is the saturation pressure,
\eqn{Q_m} is the monolayer adsorption capacity, and \eqn{C_b} is the BET constant.

For more information, see Brunauer et al. (1938): \doi{https://doi.org/10.1021/ja01269a023}
}
\examples{
Ce <- c(1, 2, 3, 4, 5)
Qe <- c(0.8, 1.5, 2.1, 2.6, 2.9)
result <- bet_model(Ce, Qe)
print(result[1:2])
print(result$`Model Summary`)
print(result$Plot)
}
\seealso{
Other linear models: \code{\link{freundlich_model}()}, \code{\link{langmuir_model}()}, \code{\link{temkin_model}()}
}
