% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{nonlinear_temkin}
\alias{nonlinear_temkin}
\title{Non-linear Temkin Model}
\usage{
nonlinear_temkin(Ce, Qe, R = 8.314, T = 298)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}

  \item{R}{Universal gas constant (default is 8.314 J/mol·K).}

  \item{T}{Temperature in Kelvin (default is 298 K).}
}
\value{
A named list of Temkin parameters and model details, including estimated parameters, model diagnostics, and a diagnostic plot.
}
\description{
The non-linear Temkin isotherm model accounts for indirect adsorbate–adsorbate interactions on heterogeneous surfaces.
It assumes that the heat of adsorption decreases linearly with increasing coverage.

The model is given by:

\deqn{Q = \frac{RT}{b_T} \cdot \ln(A_T \cdot C_e)}

where \eqn{Q} is the amount adsorbed, \eqn{C_e} is the equilibrium concentration,
\eqn{R} is the universal gas constant, \eqn{T} is the temperature in Kelvin,
\eqn{b_T} is the Temkin constant related to adsorption heat, and \eqn{A_T} is the Temkin equilibrium binding constant.

This function fits the Temkin isotherm using non-linear least squares regression.
}
\examples{
Ce <- c(0.5, 1.5, 3, 4.5, 6)
Qe <- c(0.7, 1.3, 2.0, 2.4, 2.7)
result <- nonlinear_temkin(Ce, Qe)
print(result$`Temkin A`)
print(result$`Temkin B`)
print(result$AIC)
print(result$`Pseudo R2`)
print(result$Plot)
}
\seealso{
Other nonlinear models: \code{\link{nonlinear_bet}()}, \code{\link{nonlinear_freundlich}()}, \code{\link{nonlinear_langmuir}()}
}
\concept{nonlinear}

